package cn.meteor.common.data;// Copyright (C), Created on 2021-04-03

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author ths
 * @since 1.0.0
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class BaseData {

	/** 主键 */
	@NotNull(message = "ID不能为空", groups = {Modify.class, Find.class})
	private Long id;
	/** 主键集合 */
	@NotEmpty(message = "ID集合不能为空", groups = {Remove.class})
	private List<Long> ids;

	/** 版本 */
	@NotNull(message = "悲观锁版本不能为空", groups = {Modify.class})
	private Integer version;

	/** 创建人 */
	private Long creator;

	/** 备注信息 */
	private String remark;

	/** 启用标志 */
	private Integer enabled;

	/* 分组校验 */
	public @interface Create {}
	/* 分组校验 */
	public @interface Modify {}
	/* 分组校验 */
	public @interface Find {}
	/* 分组校验 */
	public @interface Page {}
	/* 分组校验 */
	public @interface Remove {}
}
