package cn.meteor.common.model;// Copyright (C), Created on 2021-04-16

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 用户信息
 *
 * @author ths
 * @since 1.0.0
 */
@Data
public class UserInfo implements Serializable {

	private static final long serialVersionUID = 1L;

	/** 用户ID */
	@JsonSerialize(using = ToStringSerializer.class)
	private Long userId;
	/** 账号 */
	private String username;
	/** 昵称 */
	private String nickname;
	/** 头像 */
	private String avatar;
	/** 邮箱 */
	private String email;
	/** 部门id */
	private String deptId;

	/** 权限标识集合 */
	private List<String> permissions;
	/** 角色集合 */
	private List<String> roles;
	/** 第三方授权id */
	private String oauthId;

}
