/*
 * Decompiled with CFR 0.152.
 */
package cn.meteor.common.service;

import cn.hutool.extra.mail.MailAccount;
import cn.hutool.extra.mail.MailUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.meteor.common.properties.EmailProperties;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@EnableConfigurationProperties(value={EmailProperties.class})
@ConditionalOnProperty(prefix="meteor.email", name={"enabled"}, havingValue="true")
public class EmailService {
    private static final Logger log = LoggerFactory.getLogger(EmailService.class);

    public static boolean sendTencentMail(String subject, String content) {
        return EmailService.sendTencentMail(subject, content, false);
    }

    public static boolean sendTencentMail(String subject, String content, boolean isHtml) {
        try {
            EmailProperties props = (EmailProperties)SpringUtil.getBean(EmailProperties.class);
            MailAccount account = new MailAccount();
            account.setHost("smtp.exmail.qq.com");
            account.setSocketFactoryPort(465);
            account.setAuth(true);
            account.setFrom(props.getFrom());
            account.setPass(props.getPassword());
            MailUtil.send((MailAccount)account, props.getTos(), (String)subject, (String)content, (boolean)isHtml, (File[])new File[0]);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u90ae\u4ef6\u65f6\u5f02\u5e38", (Throwable)e);
            return false;
        }
        return true;
    }
}

