package cn.meteor.common.model;// Copyright (C), Created on 2021-08-11

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 树模型
 *
 * @author ths
 * @since 1.0.0
 */
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TreeModel<T> extends SysModel {

	/** 上级部门ID */
	@JsonSerialize(using = ToStringSerializer.class)
	private Long parentId;
	/** 子节点 */
	private List<T> children;
}
