/*
 * Decompiled with CFR 0.152.
 */
package cn.meteor.common.model;

import cn.hutool.core.util.ObjectUtil;
import cn.meteor.common.enums.ResultType;
import cn.meteor.common.exception.ServiceException;
import cn.meteor.common.interfaces.IResultType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Schema(title="\u54cd\u5e94\u6a21\u578b")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"success", "failure", "process"})
public class R<T>
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(R.class);
    private static final long serialVersionUID = 1L;
    @Schema(name="\u72b6\u6001\u7801", required=true)
    private int code;
    @Schema(name="\u54cd\u5e94\u6570\u636e")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private T data;
    @Schema(name="\u54cd\u5e94\u4fe1\u606f", required=true)
    private String message;

    public static <T> R<T> success() {
        return R.success(null);
    }

    public static <T> R<T> success(T data) {
        return R.create(ResultType.SUCCESS, data);
    }

    public static <T> R<T> failure() {
        return R.failure(ResultType.FAILED);
    }

    public static <T> R<T> failure(String errorMessage) {
        return R.failure(errorMessage, null);
    }

    public static <T> R<T> failure(String errorMessage, T data) {
        return R.create(ResultType.FAILED, data).setMessage(errorMessage);
    }

    public static <T> R<T> failure(IResultType resultEnum) {
        return R.create(resultEnum);
    }

    public static <T> R<T> failure(ServiceException e) {
        if (ObjectUtil.isNotNull((Object)e.getResultEnum())) {
            return R.create(e.getResultEnum());
        }
        return R.failure(e.getMessage());
    }

    public static <T> R<T> failure(Logger log, IResultType resultEnum, Exception e) {
        log.error(resultEnum.getWarning(), (Throwable)e);
        return R.create(resultEnum);
    }

    public static <T> R<T> failure(Integer influenceLine) {
        if (ObjectUtil.isNull((Object)influenceLine) || influenceLine < 1) {
            return R.failure(ResultType.FAILED);
        }
        return R.success();
    }

    public static <T> void throwError(String errorMessage) {
        throw new ServiceException(errorMessage);
    }

    private static <T> R<T> create(IResultType resultEnum) {
        return R.create(resultEnum, null);
    }

    private static <T> R<T> create(IResultType resultEnum, T data) {
        return new R<T>().setCode(resultEnum.getCode()).setMessage(resultEnum.getMessage()).setData(data);
    }

    @JsonIgnore
    public boolean isSuccess() {
        return Objects.equals(ResultType.SUCCESS.getCode(), this.code);
    }

    @JsonIgnore
    public boolean isFailure() {
        return !this.isSuccess();
    }

    protected R(RBuilder<T, ?, ?> b) {
        this.code = b.code;
        this.data = b.data;
        this.message = b.message;
    }

    public static <T> RBuilder<T, ?, ?> builder() {
        return new RBuilderImpl();
    }

    public int getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public String getMessage() {
        return this.message;
    }

    public R<T> setCode(int code) {
        this.code = code;
        return this;
    }

    public R<T> setData(T data) {
        this.data = data;
        return this;
    }

    public R<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof R)) {
            return false;
        }
        R other = (R)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof R;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "R(code=" + this.getCode() + ", data=" + this.getData() + ", message=" + this.getMessage() + ")";
    }

    public R() {
    }

    public R(int code, T data, String message) {
        this.code = code;
        this.data = data;
        this.message = message;
    }

    private static final class RBuilderImpl<T>
    extends RBuilder<T, R<T>, RBuilderImpl<T>> {
        private RBuilderImpl() {
        }

        @Override
        protected RBuilderImpl<T> self() {
            return this;
        }

        @Override
        public R<T> build() {
            return new R(this);
        }
    }

    public static abstract class RBuilder<T, C extends R<T>, B extends RBuilder<T, C, B>> {
        private int code;
        private T data;
        private String message;

        protected abstract B self();

        public abstract C build();

        public B code(int code) {
            this.code = code;
            return this.self();
        }

        public B data(T data) {
            this.data = data;
            return this.self();
        }

        public B message(String message) {
            this.message = message;
            return this.self();
        }

        public String toString() {
            return "R.RBuilder(code=" + this.code + ", data=" + this.data + ", message=" + this.message + ")";
        }
    }
}

