package cn.meteor.common.model;// Copyright (C), Created on 2021-04-03

import cn.hutool.core.date.DatePattern;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.time.LocalDateTime;

/**
 * 基础数据
 *
 * @author ths
 * @since 1.0.0
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class BaseModel {

	@JsonSerialize(using = ToStringSerializer.class)
	private Long id;

	/** 创建时间 */
	@JsonFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
	private LocalDateTime createTime;

	/** 更新时间 */
	@JsonFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
	private LocalDateTime updateTime;

	/** 创建人 */
	@JsonSerialize(using = ToStringSerializer.class)
	private Long creator;

	@JsonSerialize(using = ToStringSerializer.class)
	private Integer version;

}
