package cn.meteor.common.auth.interceptor;

import cn.hutool.json.JSONUtil;
import cn.meteor.common.core.support.StringPool;
import cn.meteor.common.enums.ResultType;
import cn.meteor.common.launch.constants.TokenConstants;
import cn.meteor.common.launch.spring.SpringUtil;
import cn.meteor.common.model.R;
import cn.meteor.common.web.model.UserInfo;
import cn.meteor.system.client.IUserClient;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 简单的登录验证
 *
 * @author ths
 * @since 1.0.0
 */
public class LoginAuthInterceptor implements HandlerInterceptor {

	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
		response.setCharacterEncoding(StringPool.UTF_8);
		response.setContentType(MediaType.APPLICATION_JSON_VALUE);
		// 从请求头中获取 Token，有则说明，是登录用户，否则拦截提示未登录
		String token = request.getHeader(TokenConstants.HEADER);
		// 不存在token，未登录
		if (token == null) {
			response.getWriter().print(JSONUtil.toJsonStr(R.failure(ResultType.TOKEN_NO)));
			return false;
		}
		// 执行判断是否存在盗用，或者过期
		IUserClient userClient = SpringUtil.getBean(IUserClient.class);
		R<UserInfo> userInfo = userClient.userInfoByToken(token);
		if (userInfo == null || userInfo.isFailure()) {
			response.getWriter().print(JSONUtil.toJsonStr(R.failure(ResultType.TOKEN_PAST)));
			return false;
		}
		return true;
	}
}
