package cn.meteor.common.auth.configure;

import cn.meteor.common.auth.interceptor.LoginAuthInterceptor;
import lombok.AllArgsConstructor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @author ths
 * @since 1.0.0
 */
@AllArgsConstructor
public class AuthMvcConfigure implements WebMvcConfigurer {

	private final LoginAuthInterceptor loginAuthInterceptor;

	/**
	 * 配置拦截的请求，与不拦截的请求
	 */
	@Override
	public void addInterceptors(InterceptorRegistry registry) {
		registry.addInterceptor(loginAuthInterceptor)
			.addPathPatterns("/**")
			.excludePathPatterns("/**/emailLogin", "/**/userInfoByToken", "/**/static/**");
	}
}
