/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.scanner;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.paoding.rose.scanner.ModuleResource;
import net.paoding.rose.scanner.ModuleResourceProviderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RestController;

public class BootModuleResourceProvider
extends ModuleResourceProviderImpl {
    private static final Logger log = LoggerFactory.getLogger(BootModuleResourceProvider.class);

    protected void afterScanning(ModuleResourceProviderImpl.Local local) {
        for (ModuleResource moduleResource : local.moduleResourceMap.values()) {
            List moduleClasses = moduleResource.getModuleClasses();
            List<Class<?>> springMvcController = this.findSpringMvcController(moduleClasses);
            moduleClasses.removeAll(springMvcController);
        }
        super.afterScanning(local);
    }

    protected List<Class<?>> findSpringMvcController(List<Class<?>> controllers) {
        ArrayList springMvcController = new ArrayList();
        for (Class<?> controller : controllers) {
            if (!this.isSpringMvc(controller)) continue;
            springMvcController.add(controller);
        }
        return springMvcController;
    }

    protected boolean isSpringMvc(Class<?> clazz) {
        Controller controller = clazz.getAnnotation(Controller.class);
        RestController restController = clazz.getAnnotation(RestController.class);
        return Objects.nonNull(controller) || Objects.nonNull(restController);
    }
}

