/*
 * Decompiled with CFR 0.152.
 */
package com.ttpai.framework.rose.boot.autoconfigure.filter;

import com.ttpai.framework.rose.boot.autoconfigure.config.RoseModulesFinder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.paoding.rose.web.RequestPath;
import net.paoding.rose.web.impl.mapping.ignored.IgnoredPath;
import net.paoding.rose.web.impl.mapping.ignored.IgnoredPathEnds;
import net.paoding.rose.web.impl.mapping.ignored.IgnoredPathEquals;
import net.paoding.rose.web.impl.mapping.ignored.IgnoredPathRegexMatch;
import net.paoding.rose.web.impl.mapping.ignored.IgnoredPathStarts;
import net.paoding.rose.web.impl.thread.Rose;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.GenericFilterBean;
import org.springframework.web.util.NestedServletException;

public class RoseBootFilter
extends GenericFilterBean {
    private static final Logger log = LoggerFactory.getLogger(RoseBootFilter.class);
    private final RoseModulesFinder roseTree;
    private IgnoredPath[] ignoredPaths = new IgnoredPath[]{new IgnoredPathStarts("/views/"), new IgnoredPathEquals("/favicon.ico")};

    public RoseBootFilter(RoseModulesFinder roseTree) {
        this.roseTree = roseTree;
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (!(req instanceof HttpServletRequest) || !(resp instanceof HttpServletResponse)) {
            chain.doFilter(req, resp);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        this.supportsRosePipe(request);
        RequestPath requestPath = new RequestPath(request);
        if (this.quicklyPass(requestPath)) {
            this.notMatched(chain, request, response, requestPath);
            return;
        }
        boolean matched = false;
        try {
            Rose rose = new Rose(this.roseTree.getModules(), this.roseTree.getMappingTree(), request, response, requestPath);
            matched = rose.start();
        }
        catch (Throwable exception) {
            this.throwServletException(requestPath, exception);
        }
        if (!matched) {
            this.notMatched(chain, request, response, requestPath);
        }
    }

    protected boolean quicklyPass(RequestPath requestPath) {
        for (IgnoredPath ignoredPath : this.ignoredPaths) {
            if (!ignoredPath.hit(requestPath)) continue;
            return true;
        }
        return false;
    }

    protected void throwServletException(RequestPath requestPath, Throwable exception) throws ServletException {
        String msg = requestPath.getMethod() + " " + requestPath.getUri();
        Object servletException = exception instanceof ServletException ? (ServletException)exception : new NestedServletException(msg, exception);
        log.error(msg, exception);
        this.getServletContext().log(msg, exception);
        throw servletException;
    }

    protected void notMatched(FilterChain chain, HttpServletRequest req, HttpServletResponse resp, RequestPath path) throws IOException, ServletException {
        if (log.isDebugEnabled()) {
            log.debug("not rose uri: " + path.getUri());
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
    }

    public void setIgnoredPaths(String[] ignoredPathStrings) {
        ArrayList<IgnoredPath> list = new ArrayList<IgnoredPath>(ignoredPathStrings.length + 2);
        for (String ignoredPath : ignoredPathStrings) {
            list.addAll(this.parseIgnoredPath(ignoredPath));
        }
        IgnoredPath[] paths = Arrays.copyOf(this.ignoredPaths, this.ignoredPaths.length + list.size());
        for (int i = this.ignoredPaths.length; i < paths.length; ++i) {
            paths[i] = (IgnoredPath)list.get(i - this.ignoredPaths.length);
        }
        this.ignoredPaths = paths;
    }

    protected List<IgnoredPath> parseIgnoredPath(String ignoredPath) {
        ArrayList<IgnoredPath> list = new ArrayList<IgnoredPath>(2);
        if (StringUtils.isEmpty((String)(ignoredPath = ignoredPath.trim()))) {
            return list;
        }
        if (ignoredPath.equals("*")) {
            list.add((IgnoredPath)new IgnoredPathEquals(""));
            list.add((IgnoredPath)new IgnoredPathStarts("/"));
            return list;
        }
        if (ignoredPath.startsWith("regex:")) {
            list.add((IgnoredPath)new IgnoredPathRegexMatch(ignoredPath.substring("regex:".length())));
            return list;
        }
        if (ignoredPath.length() > 0 && !ignoredPath.startsWith("/") && !ignoredPath.startsWith("*")) {
            ignoredPath = "/" + ignoredPath;
        }
        if (ignoredPath.endsWith("*")) {
            list.add((IgnoredPath)new IgnoredPathStarts(ignoredPath.substring(0, ignoredPath.length() - 1)));
        } else if (ignoredPath.startsWith("*")) {
            list.add((IgnoredPath)new IgnoredPathEnds(ignoredPath.substring(1)));
        } else {
            list.add((IgnoredPath)new IgnoredPathEquals(ignoredPath));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void supportsRosePipe(HttpServletRequest httpRequest) {
        Object window = httpRequest.getAttribute("$$paoding-rose-portal.window");
        if (window != null && window.getClass().getName().startsWith("net.paoding.rose.web.portal")) {
            httpRequest.setAttribute("$$paoding-rose-portal.window.in", (Object)Boolean.TRUE);
            if (log.isDebugEnabled()) {
                try {
                    log.debug("notify window '{}'", httpRequest.getAttribute("$$paoding-rose-portal.window.name"));
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
            Object object = window;
            synchronized (object) {
                window.notifyAll();
            }
        }
    }
}

