/*
 * Decompiled with CFR 0.152.
 */
package com.ttpai.framework.rose.boot.autoconfigure.config;

import java.util.List;
import javax.annotation.Resource;
import net.paoding.rose.RoseVersion;
import net.paoding.rose.scanner.ModuleResourceProvider;
import net.paoding.rose.scanning.LoadScope;
import net.paoding.rose.util.PrinteHelper;
import net.paoding.rose.web.annotation.ReqMethod;
import net.paoding.rose.web.impl.mapping.ConstantMapping;
import net.paoding.rose.web.impl.mapping.Mapping;
import net.paoding.rose.web.impl.mapping.MappingNode;
import net.paoding.rose.web.impl.mapping.TreeBuilder;
import net.paoding.rose.web.impl.module.Module;
import net.paoding.rose.web.impl.module.ModulesBuilder;
import net.paoding.rose.web.impl.thread.Engine;
import net.paoding.rose.web.impl.thread.LinkedEngine;
import net.paoding.rose.web.impl.thread.RootEngine;
import net.paoding.rose.web.instruction.InstructionExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.web.context.WebApplicationContext;

@Configuration
public class RoseModulesFinder
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(RoseModulesFinder.class);
    @Resource
    private WebApplicationContext context;
    private List<Module> modules;
    private MappingNode mappingTree;
    private final LoadScope load = new LoadScope("", "controllers");

    public void afterPropertiesSet() throws Exception {
        long startTime = System.currentTimeMillis();
        this.modules = this.prepareModules(this.context);
        this.mappingTree = this.prepareMappingTree(this.modules);
        long cost = System.currentTimeMillis() - startTime;
        String format = "[init] rose initialized, %s modules loaded, cost %sms! (version=%s)";
        String msg = String.format(format, this.modules.size(), cost, RoseVersion.getVersion());
        logger.info(msg);
        this.context.getServletContext().log(msg);
        if (logger.isDebugEnabled()) {
            logger.debug(PrinteHelper.dumpModules(this.modules));
            logger.debug("mapping tree:\n {}", (Object)PrinteHelper.list((MappingNode)this.mappingTree));
        }
    }

    protected List<Module> prepareModules(WebApplicationContext rootContext) throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info("[init/mudule] starting ...");
        }
        ModuleResourceProvider provider = this.springFactoriesFindFirst(ModuleResourceProvider.class);
        if (logger.isInfoEnabled()) {
            logger.info("[init/module] using provider: {}", (Object)provider);
            logger.info("[init/module] call 'moduleResource': to find all module resources.");
            logger.info("[init/module] load {}", (Object)this.load);
        }
        List moduleResources = provider.findModuleResources(this.load);
        if (logger.isInfoEnabled()) {
            logger.info("[init/mudule] exits 'moduleResource'");
        }
        ModulesBuilder modulesBuilder = this.springFactoriesFindFirst(ModulesBuilder.class);
        if (logger.isInfoEnabled()) {
            logger.info("[init/module] using modulesBuilder: {}", (Object)modulesBuilder);
            logger.info("[init/module] call 'moduleBuild': to build modules.");
        }
        List findModules = modulesBuilder.build(moduleResources, rootContext);
        if (logger.isInfoEnabled()) {
            logger.info("[init/module] exits from 'moduleBuild'");
            logger.info("[init/mudule] found {} modules.", (Object)findModules.size());
        }
        return findModules;
    }

    protected MappingNode prepareMappingTree(List<Module> modules) {
        ConstantMapping rootMapping = new ConstantMapping("");
        MappingNode mappingNode = new MappingNode((Mapping)rootMapping);
        InstructionExecutor instructionExecutor = this.springFactoriesFindFirst(InstructionExecutor.class);
        LinkedEngine rootEngine = new LinkedEngine(null, (Engine)new RootEngine(instructionExecutor), mappingNode);
        mappingNode.getMiddleEngines().addEngine(ReqMethod.ALL, rootEngine);
        TreeBuilder treeBuilder = new TreeBuilder();
        treeBuilder.create(mappingNode, modules);
        return mappingNode;
    }

    protected <T> T springFactoriesFindFirst(Class<T> clazz) {
        List resourceProviders = SpringFactoriesLoader.loadFactories(clazz, (ClassLoader)Thread.currentThread().getContextClassLoader());
        if (resourceProviders.isEmpty()) {
            throw new IllegalArgumentException("SpringFactoriesLoader not Found " + clazz.getName());
        }
        Object instance = resourceProviders.get(0);
        if (resourceProviders.size() > 1) {
            logger.warn("SpringFactoriesLoader find Multi {}, Use {}", (Object)clazz.getName(), (Object)instance.getClass().getName());
        }
        return (T)instance;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public MappingNode getMappingTree() {
        return this.mappingTree;
    }
}

