/*
 * Decompiled with CFR 0.152.
 */
package com.ttpai.framework.rose.boot.autoconfigure;

import com.ttpai.framework.rose.boot.autoconfigure.config.RoseModulesFinder;
import com.ttpai.framework.rose.boot.autoconfigure.filter.RoseBootFilter;
import java.util.Arrays;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import zzz.ZAutoConfiguration;

@AutoConfigureAfter(value={ZAutoConfiguration.class})
@ConditionalOnClass(name={"net.paoding.rose.RoseFilter"})
class RoseAutoConfiguration {
    @Value(value="${ttpai.rose.boot.filter.patterns:/*}")
    private String patterns;
    @Value(value="${ttpai.rose.boot.filter.ignore.paths:}")
    private String ignorePaths;

    RoseAutoConfiguration() {
    }

    @Bean
    public RoseModulesFinder roseModulesFinder() {
        return new RoseModulesFinder();
    }

    @Bean
    public RoseBootFilter roseBootFilter(RoseModulesFinder modules) {
        RoseBootFilter roseBootFilter = new RoseBootFilter(modules);
        if (StringUtils.isNotBlank((String)this.ignorePaths)) {
            roseBootFilter.setIgnoredPaths(this.ignorePaths.split(","));
        }
        return new RoseBootFilter(modules);
    }

    @Bean
    public FilterRegistrationBean roseBootFilterRegistration(RoseBootFilter filter) {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)filter);
        bean.setUrlPatterns(Arrays.asList(this.patterns.split(",")));
        bean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.INCLUDE));
        return bean;
    }
}

