/*
 * Decompiled with CFR 0.152.
 */
package com.ttpai.framework.build.extension;

import com.ttpai.framework.build.extension.AbstractExtension;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="deploy")
public class WarSkipDeployExtension
extends AbstractExtension {
    private static final String SKIP_PROPERTIES = "ttpai.parents.extension.war.skip";

    @Nullable
    public String skipProperties() {
        return SKIP_PROPERTIES;
    }

    public void afterProjectsReadPretty(MavenSession session) {
        List allProjects = session.getAllProjects();
        for (MavenProject currentProject : allProjects) {
            this.projectHandler(currentProject);
        }
    }

    protected void projectHandler(MavenProject currentProject) {
        String projectName = currentProject.getName();
        String packaging = currentProject.getPackaging();
        if (!"war".equals(packaging)) {
            this.logger.info(" {} packaging is not war ({}), This extension will Skip ", (Object)projectName, (Object)packaging);
            return;
        }
        if (this.shouldSkip(currentProject.getProperties())) {
            this.logger.info("{} <{}>true</{}>,  will Skip", new Object[]{projectName, this.skipProperties(), this.skipProperties()});
            return;
        }
        this.logger.info(" {} packaging is war, will skip install & deploy", (Object)projectName);
        currentProject.getProperties().setProperty("maven.deploy.skip", "true");
        currentProject.getProperties().setProperty("maven.install.skip", "true");
    }
}

