/*
 * Decompiled with CFR 0.152.
 */
package com.ttpai.framework.mybatis.config;

import com.ttpai.framework.mybatis.config.DefaultMyBatisConfig;
import com.ttpai.framework.mybatis.config.RelaxedNames;
import org.apache.ibatis.session.Configuration;
import org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class MyBatisConfigurationCustomer
implements ConfigurationCustomizer {
    private final Environment environment;

    public MyBatisConfigurationCustomer(Environment environment) {
        this.environment = environment;
    }

    public void customize(Configuration configuration) {
        for (DefaultMyBatisConfig value : DefaultMyBatisConfig.values()) {
            String configKey = value.getKey();
            String defConfig = this.environment.getProperty(configKey);
            if (!StringUtils.isEmpty((Object)defConfig)) continue;
            boolean found = false;
            RelaxedNames relaxedNames = RelaxedNames.forCamelCase(configKey);
            for (String relaxedName : relaxedNames) {
                String property = this.environment.getProperty(relaxedName);
                if (StringUtils.isEmpty((Object)property)) continue;
                found = true;
                break;
            }
            if (found) continue;
            value.setConfig(configuration);
        }
    }
}

