/*
 * Decompiled with CFR 0.152.
 */
package com.ttpai.framework.mybatis.autoconfigure.datasource.choose;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class MyBatisAutoConfigurationExclude
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    private static final String EXCLUDE_KEY = "spring.autoconfigure.exclude";

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        this.environmentPrepared(event.getEnvironment());
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
        ArrayList excludes = (ArrayList)environment.getProperty(EXCLUDE_KEY, ArrayList.class, new ArrayList());
        excludes.add(MybatisAutoConfiguration.class.getName());
        Map<String, String> exclude = Collections.singletonMap(EXCLUDE_KEY, String.join((CharSequence)",", excludes));
        MapPropertySource mapPropertySource = new MapPropertySource(this.getClass().getName(), exclude);
        environment.getPropertySources().addFirst((PropertySource)mapPropertySource);
    }
}

