/*
 * Decompiled with CFR 0.152.
 */
package com.ttpai.framework.mybatis.autoconfigure.datasource.support;

import com.ttpai.framework.mybatis.autoconfigure.datasource.MyBatisMultiDataSourceProcessorConfigure;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.TypeHandler;
import org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer;
import org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration;
import org.mybatis.spring.boot.autoconfigure.MybatisProperties;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.io.ResourceLoader;

@EnableConfigurationProperties(value={MybatisProperties.class})
public class MyBatisSqlSessionFactoryInit
implements InitializingBean,
ServletContextInitializer,
PriorityOrdered {
    @Resource
    private DefaultListableBeanFactory beanFactory;
    @Resource
    private MybatisProperties properties;
    @Resource
    private ObjectProvider<Interceptor[]> interceptorsProvider;
    @Resource
    private ObjectProvider<TypeHandler[]> typeHandlersProvider;
    @Resource
    private ObjectProvider<LanguageDriver[]> languageDriversProvider;
    @Resource
    private ResourceLoader resourceLoader;
    @Resource
    private ObjectProvider<DatabaseIdProvider> databaseIdProvider;
    @Resource
    private ObjectProvider<List<ConfigurationCustomizer>> configurationCustomizersProvider;

    public void afterPropertiesSet() throws Exception {
        Map mappings = (Map)this.beanFactory.getBean(MyBatisMultiDataSourceProcessorConfigure.MAPPING_BEAN_NAME, Map.class);
        for (Map.Entry packageDatasource : mappings.entrySet()) {
            DataSource dataSource = (DataSource)this.beanFactory.getBean((String)packageDatasource.getValue(), DataSource.class);
            Configuration configuration = new Configuration();
            if (this.properties.getConfiguration() != null) {
                BeanUtils.copyProperties((Object)this.properties.getConfiguration(), (Object)configuration);
            }
            this.properties.setConfiguration(configuration);
            MybatisAutoConfiguration delegation = new MybatisAutoConfiguration(this.properties, this.interceptorsProvider, this.typeHandlersProvider, this.languageDriversProvider, this.resourceLoader, this.databaseIdProvider, this.configurationCustomizersProvider);
            delegation.afterPropertiesSet();
            SqlSessionFactory sqlSessionFactory = delegation.sqlSessionFactory(dataSource);
            this.beanFactory.registerSingleton(SqlSessionFactory.class.getSimpleName() + "." + (String)packageDatasource.getKey(), (Object)sqlSessionFactory);
        }
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
    }

    public int getOrder() {
        return 0;
    }
}

