/*
 * Decompiled with CFR 0.152.
 */
package com.ttpai.framework.mybatis.autoconfigure.datasource.listener;

import java.util.Collections;
import java.util.Map;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class DefaultDataSourceInitListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    private static final String KEY = "spring.datasource.initialize";

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        if (environment.containsProperty(KEY)) {
            return;
        }
        Map<String, Boolean> defaultConf = Collections.singletonMap(KEY, false);
        MapPropertySource mapPropertySource = new MapPropertySource(this.getClass().getName(), defaultConf);
        environment.getPropertySources().addLast((PropertySource)mapPropertySource);
    }
}

