/*
 * Decompiled with CFR 0.152.
 */
package com.ttpai.framework.mybatis.autoconfigure.datasource;

import com.ttpai.framework.mybatis.autoconfigure.common.condition.ConditionalOnBeanCount;
import com.ttpai.framework.mybatis.autoconfigure.datasource.support.MyBatisSqlSessionFactoryInit;
import com.ttpai.framework.mybatis.autoconfigure.datasource.support.MyBatisSqlSessionFactoryInitEvent;
import com.ttpai.framework.mybatis.autoconfigure.datasource.support.MyBatisSqlSessionFactoryInitEventListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.mapper.ClassPathMapperScanner;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;
import z.ZAutoConfiguration;

@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, ZAutoConfiguration.class})
@ConditionalOnBeanCount(type={DataSource.class}, count=ConditionalOnBeanCount.Count.MULTI)
@Import(value={MyBatisSqlSessionFactoryInit.class, MyBatisSqlSessionFactoryInitEventListener.class})
public class MyBatisMultiDataSourceProcessorConfigure
implements ApplicationContextAware,
BeanDefinitionRegistryPostProcessor {
    public static final String[] AUTO_PREFIX = new String[]{"jade.dataSource.", "mybatis.dataSource.", "ttpai.mybatis.dataSource."};
    public static final String MAPPING_BEAN_NAME = MyBatisMultiDataSourceProcessorConfigure.class.getSimpleName() + ".packageDataSourceMappings";
    private ApplicationContext applicationContext;
    private BeanDefinitionRegistry registry;
    private List<String> defaultPackageNames;
    private static final String CONFIG_PREFIX = "ttpai.mybatis.datasource.mapping.";

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.registry = registry;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.defaultPackageNames = this.findDefaultPackages((BeanFactory)beanFactory);
        Set<String> dataSourceNames = this.filterDataSourceNames(beanFactory);
        if (dataSourceNames.isEmpty()) {
            return;
        }
        Map<String, String> packageDataSourceMappings = this.findDataSourceMappings(dataSourceNames);
        ArrayList<String> packages = new ArrayList<String>(packageDataSourceMappings.keySet());
        Collections.sort(packages);
        Collections.reverse(packages);
        packages.forEach(this::scan);
        beanFactory.registerSingleton(MAPPING_BEAN_NAME, packageDataSourceMappings);
        this.applicationContext.publishEvent((ApplicationEvent)new MyBatisSqlSessionFactoryInitEvent(this.applicationContext));
    }

    protected List<String> findDefaultPackages(BeanFactory beanFactory) {
        return AutoConfigurationPackages.get((BeanFactory)beanFactory);
    }

    protected Set<String> filterDataSourceNames(ConfigurableListableBeanFactory beanFactory) {
        String[] definitionNames;
        HashSet<String> dataSourceBeanName = new HashSet<String>();
        for (String beanName : definitionNames = beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition;
            Class beanType = beanFactory.getType(beanName);
            if (null == beanType || !DataSource.class.isAssignableFrom(beanType) || (beanDefinition = beanFactory.getBeanDefinition(beanName)).isAbstract() || beanDefinition.isPrototype()) continue;
            dataSourceBeanName.add(beanName);
        }
        return dataSourceBeanName;
    }

    protected int hasAutoPrefix(String beanName) {
        for (String prefix : AUTO_PREFIX) {
            if (!beanName.startsWith(prefix)) continue;
            return prefix.length();
        }
        return 0;
    }

    protected Map<String, String> findDataSourceMappings(Set<String> dataSourceNames) {
        HashMap<String, String> packageBeanMappings = new HashMap<String, String>();
        if (1 == dataSourceNames.size() && !this.defaultPackageNames.isEmpty()) {
            for (String defaultPackageName : this.defaultPackageNames) {
                packageBeanMappings.put(defaultPackageName, dataSourceNames.iterator().next());
            }
        }
        for (String dataSourceName : dataSourceNames) {
            List<String> packages;
            int prefixIndex = this.hasAutoPrefix(dataSourceName);
            if (prefixIndex > 0) {
                String foundPackage = dataSourceName.substring(prefixIndex);
                this.checkAndCacheMapping(packageBeanMappings, foundPackage, dataSourceName);
            }
            if ((packages = this.findDataSourcePackage(dataSourceName)).isEmpty()) continue;
            for (String pkg : packages) {
                this.checkAndCacheMapping(packageBeanMappings, pkg, dataSourceName);
            }
        }
        return packageBeanMappings;
    }

    private void checkAndCacheMapping(Map<String, String> packageBeanMappings, String packageName, String dataSourceName) {
        String existedDataSource = packageBeanMappings.get(packageName);
        if (existedDataSource != null && !existedDataSource.equals(dataSourceName)) {
            throw new IllegalStateException("\u6570\u636e\u6e90\u914d\u7f6e\u4fe1\u606f\u6709\u8bef,\u591a\u4e2a\u6570\u636e\u6e90\u4e0d\u80fd\u6620\u5c04\u5230\u540c\u4e00\u4e2a\u7684\u5305\u540d\u4e0a\u3010package: " + packageName + "\u3011,\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u76f8\u5173\u914d\u7f6e");
        }
        packageBeanMappings.put(packageName, dataSourceName);
    }

    protected List<String> findDataSourcePackage(String dataSourceBeanName) {
        String[] aliases;
        ArrayList<String> packages = new ArrayList<String>();
        String packageNames = this.applicationContext.getEnvironment().getProperty(CONFIG_PREFIX + dataSourceBeanName);
        if (packageNames != null) {
            packages.addAll(StringUtils.commaDelimitedListToSet((String)packageNames));
        }
        if ((aliases = this.applicationContext.getAliases(dataSourceBeanName)).length > 0) {
            for (String alias : aliases) {
                int prefixIndex = this.hasAutoPrefix(alias);
                if (prefixIndex <= 0) continue;
                packages.add(alias.substring(prefixIndex));
            }
        }
        return packages;
    }

    protected void scan(String packages) {
        ClassPathMapperScanner scanner = new ClassPathMapperScanner(this.registry);
        scanner.setAnnotationClass(Mapper.class);
        scanner.setResourceLoader((ResourceLoader)this.applicationContext);
        scanner.setSqlSessionFactoryBeanName(SqlSessionFactory.class.getSimpleName() + "." + packages);
        scanner.registerFilters();
        scanner.scan(new String[]{packages});
    }
}

