/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.registry.impl;

import com.pi4j.exception.InitializeException;
import com.pi4j.exception.LifecycleException;
import com.pi4j.io.IO;
import com.pi4j.io.exception.IOAlreadyExistsException;
import com.pi4j.io.exception.IOException;
import com.pi4j.io.exception.IOInvalidIDException;
import com.pi4j.io.exception.IONotFoundException;
import com.pi4j.io.exception.IOShutdownException;
import com.pi4j.registry.impl.RuntimeRegistry;
import com.pi4j.runtime.Runtime;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRuntimeRegistry
implements RuntimeRegistry {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Runtime runtime = null;
    private Map<String, IO> instances = new ConcurrentHashMap<String, IO>();

    public static RuntimeRegistry newInstance(Runtime runtime) {
        return new DefaultRuntimeRegistry(runtime);
    }

    private DefaultRuntimeRegistry(Runtime runtime) {
        this.runtime = runtime;
    }

    @Override
    public RuntimeRegistry add(IO instance) throws IOInvalidIDException, IOAlreadyExistsException {
        String _id = this.validateId(instance.id());
        if (this.instances.containsKey(_id)) {
            throw new IOAlreadyExistsException(_id);
        }
        this.instances.put(_id, instance);
        return this;
    }

    @Override
    public <T extends IO> T get(String id, Class<T> type) throws IOInvalidIDException, IONotFoundException {
        String _id = this.validateId(id);
        if (!this.instances.containsKey(_id)) {
            throw new IONotFoundException(_id);
        }
        return (T)this.instances.get(_id);
    }

    @Override
    public <T extends IO> T get(String id) throws IOInvalidIDException, IONotFoundException {
        String _id = this.validateId(id);
        if (!this.instances.containsKey(_id)) {
            throw new IONotFoundException(_id);
        }
        return (T)this.instances.get(_id);
    }

    @Override
    public <T extends IO> T remove(String id) throws IONotFoundException, IOInvalidIDException, IOShutdownException {
        String _id = this.validateId(id);
        IO shutdownInstance = null;
        if (!this.exists(_id)) {
            throw new IONotFoundException(_id);
        }
        try {
            shutdownInstance = this.instances.get(_id);
            shutdownInstance.shutdown(this.runtime.context());
        }
        catch (LifecycleException e) {
            this.logger.error(e.getMessage(), e);
            throw new IOShutdownException(shutdownInstance, e);
        }
        this.instances.remove(_id);
        return (T)shutdownInstance;
    }

    @Override
    public boolean exists(String id) {
        String _id = null;
        try {
            _id = this.validateId(id);
            return this.instances.containsKey(_id);
        }
        catch (IOInvalidIDException e) {
            return false;
        }
    }

    @Override
    public Map<String, ? extends IO> all() {
        return Collections.unmodifiableMap(this.instances);
    }

    @Override
    public boolean exists(String id, Class<? extends IO> type) {
        String _id = null;
        try {
            _id = this.validateId(id);
            if (!this.instances.containsKey(_id)) {
                return false;
            }
            IO instance = this.instances.get(id);
            return type.isAssignableFrom(instance.getClass());
        }
        catch (IOInvalidIDException e) {
            return false;
        }
    }

    private String validateId(String id) throws IOInvalidIDException {
        if (id == null) {
            throw new IOInvalidIDException();
        }
        String validatedId = id.trim();
        if (validatedId.isEmpty()) {
            throw new IOInvalidIDException();
        }
        return validatedId;
    }

    @Override
    public RuntimeRegistry shutdown() {
        this.all().values().forEach(instance -> {
            try {
                this.remove(instance.id());
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), e);
            }
        });
        return this;
    }

    @Override
    public RuntimeRegistry initialize() throws InitializeException {
        return this;
    }
}

