/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.provider.exception;

import com.pi4j.io.IOType;
import com.pi4j.provider.Provider;
import com.pi4j.provider.exception.ProviderException;

public class ProviderNotFoundException
extends ProviderException {
    public ProviderNotFoundException() {
        super("Pi4J provider could not be detected.  Please include a 'provider' JAR in the classpath.");
    }

    public ProviderNotFoundException(String providerId) {
        super("Pi4J provider [" + providerId + "] could not be found.  Please include this 'provider' JAR in the classpath.");
    }

    public ProviderNotFoundException(IOType ioType) {
        super("Pi4J provider IO type [" + String.valueOf((Object)ioType) + "] could not be found.  Please include this 'provider' JAR in the classpath for this provider type.");
    }

    public ProviderNotFoundException(String providerId, IOType ioType) {
        super("Pi4J provider [" + providerId + "] of type [" + String.valueOf((Object)ioType) + "] could not be found.  Please include this 'provider' JAR in the classpath.");
    }

    public ProviderNotFoundException(String providerId, Class<? extends Provider> providerClass) {
        super("Pi4J provider [" + providerId + "] of class [" + providerClass.getName() + "] could not be found.  Please include this 'provider' JAR in the classpath.");
    }

    public ProviderNotFoundException(Class<? extends Provider> providerClass) {
        super("Pi4J provider class [" + String.valueOf(providerClass) + "] could not be found.  Please include this 'provider' JAR in the classpath for this provider class.");
    }
}

