/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.provider;

import com.pi4j.config.Config;
import com.pi4j.context.Context;
import com.pi4j.exception.InitializeException;
import com.pi4j.exception.LifecycleException;
import com.pi4j.exception.ShutdownException;
import com.pi4j.extension.ExtensionBase;
import com.pi4j.io.IO;
import com.pi4j.provider.Provider;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProviderBase<PROVIDER_TYPE extends Provider, IO_TYPE extends IO, CONFIG_TYPE extends Config>
extends ExtensionBase<PROVIDER_TYPE>
implements Provider<PROVIDER_TYPE, IO_TYPE, CONFIG_TYPE> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Context context;

    public ProviderBase() {
    }

    public ProviderBase(String id) {
        super(id);
    }

    public ProviderBase(String id, String name) {
        super(id, name);
    }

    @Override
    public PROVIDER_TYPE initialize(Context context) throws InitializeException {
        this.context = context;
        return (PROVIDER_TYPE)this;
    }

    @Override
    public PROVIDER_TYPE shutdown(Context context) throws ShutdownException {
        Map<String, IO> instances = context.registry().allByProvider(this.id(), IO.class);
        instances.forEach((address, instance) -> {
            try {
                instance.shutdown(context);
            }
            catch (LifecycleException e) {
                this.logger.error(e.getMessage(), e);
            }
        });
        return (PROVIDER_TYPE)this;
    }

    @Override
    public Context context() {
        return this.context;
    }
}

