/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.linuxfs.provider.pwm;

import com.pi4j.io.exception.IOException;
import com.pi4j.io.pwm.Pwm;
import com.pi4j.io.pwm.PwmConfig;
import com.pi4j.io.pwm.PwmProviderBase;
import com.pi4j.io.pwm.PwmType;
import com.pi4j.plugin.linuxfs.internal.LinuxPwm;
import com.pi4j.plugin.linuxfs.provider.pwm.LinuxFsPwm;
import com.pi4j.plugin.linuxfs.provider.pwm.LinuxFsPwmProvider;

public class LinuxFsPwmProviderImpl
extends PwmProviderBase
implements LinuxFsPwmProvider {
    final String pwmFileSystemPath;
    final int pwmChip;

    public LinuxFsPwmProviderImpl(String pwmFileSystemPath, int pwmChip) {
        this.id = "linuxfs-pwm";
        this.name = "LinuxFS PWM Provider";
        this.pwmFileSystemPath = pwmFileSystemPath;
        this.pwmChip = pwmChip;
    }

    public LinuxFsPwmProviderImpl(String pwmFileSystemPath) {
        this.id = "linuxfs-pwm";
        this.name = "LinuxFS PWM Provider";
        this.pwmFileSystemPath = pwmFileSystemPath;
        this.pwmChip = LinuxPwm.DEFAULT_PWM_CHIP;
    }

    @Override
    public Pwm create(PwmConfig config) {
        if (config.pwmType() == PwmType.HARDWARE) {
            LinuxPwm pwm = new LinuxPwm(this.pwmFileSystemPath, this.pwmChip, config.address());
            return new LinuxFsPwm(pwm, this, config);
        }
        throw new IOException("The Linux file system PWM provider does not support software-emulated PWM pins; PIN ADDRESS=" + config.address());
    }
}

