/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.linuxfs.provider.gpio.digital;

import com.pi4j.context.Context;
import com.pi4j.exception.InitializeException;
import com.pi4j.exception.ShutdownException;
import com.pi4j.io.gpio.digital.DigitalInput;
import com.pi4j.io.gpio.digital.DigitalInputBase;
import com.pi4j.io.gpio.digital.DigitalInputConfig;
import com.pi4j.io.gpio.digital.DigitalInputProvider;
import com.pi4j.io.gpio.digital.DigitalState;
import com.pi4j.io.gpio.digital.DigitalStateChangeEvent;
import com.pi4j.io.gpio.digital.PullResistance;
import com.pi4j.plugin.linuxfs.internal.LinuxGpio;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxFsDigitalInput
extends DigitalInputBase
implements DigitalInput {
    protected final LinuxGpio gpio;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ExecutorService executor = Executors.newSingleThreadExecutor(r -> new Thread(r, "Pi4J.GPIO.Monitor"));
    protected DigitalState state = DigitalState.UNKNOWN;
    Runnable monitorThread = new Runnable(){

        @Override
        public void run() {
            try {
                WatchKey key;
                LinuxFsDigitalInput.this.logger.trace("monitoring thread watching GPIO [" + ((DigitalInputConfig)LinuxFsDigitalInput.this.config).address() + "]; " + LinuxFsDigitalInput.this.gpio.getPinPath());
                WatchService watchService = FileSystems.getDefault().newWatchService();
                Path path = Paths.get(LinuxFsDigitalInput.this.gpio.getPinPath(), new String[0]);
                path.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
                while ((key = watchService.take()) != null) {
                    for (WatchEvent<?> event : key.pollEvents()) {
                        DigitalState newState;
                        if (event.kind() != StandardWatchEventKinds.ENTRY_MODIFY || !event.context().toString().equalsIgnoreCase("value") || (newState = LinuxFsDigitalInput.this.gpio.state()) == LinuxFsDigitalInput.this.state) continue;
                        LinuxFsDigitalInput.this.state = newState;
                        LinuxFsDigitalInput.this.dispatch(new DigitalStateChangeEvent<LinuxFsDigitalInput>(LinuxFsDigitalInput.this, newState));
                    }
                    key.reset();
                }
            }
            catch (IOException e) {
                LinuxFsDigitalInput.this.logger.error(e.getMessage(), e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };

    public LinuxFsDigitalInput(LinuxGpio gpio, DigitalInputProvider provider, DigitalInputConfig config) {
        super(provider, config);
        this.gpio = gpio;
    }

    @Override
    public DigitalInput initialize(Context context) throws InitializeException {
        this.logger.trace("initializing GPIO [" + ((DigitalInputConfig)this.config).address() + "]; " + this.gpio.getPinPath());
        try {
            if (!this.gpio.isExported()) {
                this.logger.trace("exporting GPIO [" + ((DigitalInputConfig)this.config).address() + "]; " + this.gpio.getPinPath());
                this.gpio.export();
            } else {
                this.logger.trace("GPIO [" + ((DigitalInputConfig)this.config).address() + "] is already exported; " + this.gpio.getPinPath());
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
            throw new InitializeException("Unable to export GPIO [" + ((DigitalInputConfig)this.config).address() + "] @ <" + this.gpio.systemPath() + ">; " + e.getMessage(), e);
        }
        try {
            this.logger.trace("set direction [IN] on GPIO " + this.gpio.getPinPath());
            this.gpio.direction(LinuxGpio.Direction.IN);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
            throw new InitializeException("Unable to set GPIO [" + ((DigitalInputConfig)this.config).address() + "] DIRECTION=[IN] @ <" + this.gpio.pinPath() + ">; " + e.getMessage(), e);
        }
        if (((DigitalInputConfig)this.config).pull() == PullResistance.PULL_DOWN || ((DigitalInputConfig)this.config).pull() == PullResistance.PULL_UP || ((DigitalInputConfig)this.config).pull() == PullResistance.OFF) {
            // empty if block
        }
        try {
            this.state = this.gpio.state();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
            throw new InitializeException("Unable to get GPIO [" + ((DigitalInputConfig)this.config).address() + "] state @ <" + this.gpio.pinPath() + ">; " + e.getMessage(), e);
        }
        try {
            if (this.gpio.isInterruptSupported()) {
                this.gpio.interruptEdge(LinuxGpio.Edge.BOTH);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
            throw new InitializeException("Unable to set GPIO [" + ((DigitalInputConfig)this.config).address() + "] INTERRUPT EDGE=[BOTH] @ <" + this.gpio.pinPath() + ">; " + e.getMessage(), e);
        }
        super.initialize(context);
        this.logger.trace("start monitoring thread for GPIO [" + ((DigitalInputConfig)this.config).address() + "]; " + this.gpio.getPinPath());
        this.executor.submit(this.monitorThread);
        return this;
    }

    @Override
    public DigitalInput shutdown(Context context) throws ShutdownException {
        this.logger.trace("shutdown GPIO [" + ((DigitalInputConfig)this.config).address() + "]; " + this.gpio.getPinPath());
        this.logger.trace("shutdown monitoring thread for GPIO [" + ((DigitalInputConfig)this.config).address() + "]; " + this.gpio.getPinPath());
        this.executor.shutdown();
        super.shutdown(context);
        try {
            this.logger.trace("un-exporting GPIO [" + ((DigitalInputConfig)this.config).address() + "]; " + this.gpio.getPinPath());
            this.gpio.unexport();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
            throw new ShutdownException("Failed to UN-EXPORT GPIO [" + ((DigitalInputConfig)this.config()).address() + "] @ <" + this.gpio.systemPath() + ">; " + e.getMessage(), e);
        }
        return this;
    }

    @Override
    public DigitalState state() {
        this.logger.trace("get state on GPIO [" + ((DigitalInputConfig)this.config).address() + "]; " + this.gpio.getPinPath());
        try {
            this.state = this.gpio.state();
            return this.state;
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
            throw new com.pi4j.io.exception.IOException(e.getMessage(), e);
        }
    }
}

