/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.linuxfs;

import com.pi4j.extension.Plugin;
import com.pi4j.extension.PluginService;
import com.pi4j.plugin.linuxfs.internal.LinuxGpio;
import com.pi4j.plugin.linuxfs.internal.LinuxPwm;
import com.pi4j.plugin.linuxfs.provider.gpio.digital.LinuxFsDigitalInputProvider;
import com.pi4j.plugin.linuxfs.provider.gpio.digital.LinuxFsDigitalOutputProvider;
import com.pi4j.plugin.linuxfs.provider.i2c.LinuxFsI2CProvider;
import com.pi4j.plugin.linuxfs.provider.pwm.LinuxFsPwmProvider;
import com.pi4j.provider.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxFsPlugin
implements Plugin {
    public static final String NAME = "LinuxFS";
    public static final String ID = "linuxfs";
    public static final String ANALOG_OUTPUT_PROVIDER_NAME = "LinuxFS Analog Output (GPIO) Provider";
    public static final String ANALOG_OUTPUT_PROVIDER_ID = "linuxfs-analog-output";
    public static final String DIGITAL_INPUT_PROVIDER_NAME = "LinuxFS Digital Input (GPIO) Provider";
    public static final String DIGITAL_INPUT_PROVIDER_ID = "linuxfs-digital-input";
    public static final String DIGITAL_OUTPUT_PROVIDER_NAME = "LinuxFS Digital Output (GPIO) Provider";
    public static final String DIGITAL_OUTPUT_PROVIDER_ID = "linuxfs-digital-output";
    public static final String PWM_PROVIDER_NAME = "LinuxFS PWM Provider";
    public static final String PWM_PROVIDER_ID = "linuxfs-pwm";
    public static final String I2C_PROVIDER_NAME = "LinuxFS I2C Provider";
    public static final String I2C_PROVIDER_ID = "linuxfs-i2c";
    public static String DEFAULT_GPIO_FILESYSTEM_PATH = LinuxGpio.DEFAULT_SYSTEM_PATH;
    public static String DEFAULT_PWM_FILESYSTEM_PATH = LinuxPwm.DEFAULT_SYSTEM_PATH;
    public static int DEFAULT_PWM_CHIP = LinuxPwm.DEFAULT_PWM_CHIP;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void initialize(PluginService service) {
        String gpioFileSystemPath = DEFAULT_GPIO_FILESYSTEM_PATH;
        String pwmFileSystemPath = DEFAULT_PWM_FILESYSTEM_PATH;
        int pwmChip = DEFAULT_PWM_CHIP;
        if (service.context().properties().has("linux.gpio.system.path")) {
            gpioFileSystemPath = service.context().properties().get("linux.gpio.system.path", gpioFileSystemPath);
        }
        if (service.context().properties().has("linux.pwm.system.path")) {
            pwmFileSystemPath = service.context().properties().get("linux.pwm.system.path", pwmFileSystemPath);
        }
        if (service.context().properties().has("linux.pwm.chip")) {
            try {
                pwmChip = Integer.parseInt(service.context().properties().get("linux.pwm.chip", Integer.toString(pwmChip)));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), e);
            }
        }
        Provider[] providers = new Provider[]{LinuxFsDigitalInputProvider.newInstance(gpioFileSystemPath), LinuxFsDigitalOutputProvider.newInstance(gpioFileSystemPath), LinuxFsPwmProvider.newInstance(pwmFileSystemPath, pwmChip), LinuxFsI2CProvider.newInstance()};
        service.register(providers);
    }
}

