/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.platform.impl;

import com.pi4j.exception.InitializeException;
import com.pi4j.exception.ShutdownException;
import com.pi4j.platform.Platform;
import com.pi4j.platform.Platforms;
import com.pi4j.platform.exception.PlatformAlreadyExistsException;
import com.pi4j.platform.exception.PlatformException;
import com.pi4j.platform.exception.PlatformInitializeException;
import com.pi4j.platform.exception.PlatformNotFoundException;
import com.pi4j.platform.impl.RuntimePlatforms;
import com.pi4j.runtime.Runtime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRuntimePlatforms
implements RuntimePlatforms {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Runtime runtime = null;
    protected Platform defaultPlatform = null;
    private Map<String, Platform> platforms = new ConcurrentHashMap<String, Platform>();

    public static RuntimePlatforms newInstance(Runtime runtime) throws PlatformNotFoundException {
        return new DefaultRuntimePlatforms(runtime);
    }

    private DefaultRuntimePlatforms(Runtime runtime) throws PlatformNotFoundException {
        this.runtime = runtime;
    }

    @Override
    public Map<String, Platform> all() {
        return Collections.unmodifiableMap(this.platforms);
    }

    @Override
    public boolean exists(String platformId) {
        if (this.platforms.containsKey(platformId)) {
            return true;
        }
        try {
            Class<?> platformClass = Class.forName(platformId);
            if (platformClass != null && Platform.class.isAssignableFrom(platformClass)) {
                for (Platform platform : this.platforms.values()) {
                    if (!platformClass.isInstance(platform)) continue;
                    return true;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        for (Platform platform : this.platforms.values()) {
            if (!platform.getClass().getName().equalsIgnoreCase(platformId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Platform get(String platformId) throws PlatformNotFoundException {
        if (this.platforms.containsKey(platformId)) {
            return this.platforms.get(platformId);
        }
        try {
            Class<?> platformClass = Class.forName(platformId);
            if (platformClass != null && Platform.class.isAssignableFrom(platformClass)) {
                for (Platform platform : this.platforms.values()) {
                    if (!platformClass.isInstance(platform)) continue;
                    return platform;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new PlatformNotFoundException(platformId);
    }

    public Platform defaultPlatform() {
        return this.defaultPlatform;
    }

    @Override
    public RuntimePlatforms shutdown() throws ShutdownException {
        this.logger.trace("invoked 'shutdown();'");
        ShutdownException shutdownException = null;
        Set<String> platformIds = this.platforms.keySet();
        for (String platformId : platformIds) {
            try {
                this.remove(platformId);
            }
            catch (PlatformException e) {
                shutdownException = new ShutdownException(platformId, e);
            }
        }
        this.platforms.clear();
        if (shutdownException != null) {
            throw shutdownException;
        }
        return this;
    }

    @Override
    public RuntimePlatforms initialize(Collection<Platform> platforms) throws InitializeException {
        if (platforms != null && !platforms.isEmpty()) {
            this.logger.trace("adding platforms: [count={}]", (Object)platforms.size());
            for (Platform platform : platforms) {
                if (platform == null) continue;
                this.logger.trace("platform: [id={}; name={}; class={}]", platform.id(), platform.name(), platform.getClass().getName());
                try {
                    this.add(new Platform[]{platform});
                }
                catch (Exception ex) {
                    this.logger.error("unable to 'initialize()' platform: [id={}; name={}]; {}", platform.id(), platform.name(), ex.getMessage());
                }
            }
        }
        this.logger.debug("platforms loaded [{}]", (Object)this.platforms.size());
        if (this.runtime.context().config().hasDefaultPlatform() && this.platforms.containsKey(this.runtime.context().config().getDefaultPlatform())) {
            this.defaultPlatform = this.platforms.get(this.runtime.context().config().getDefaultPlatform());
        }
        return this;
    }

    private <T extends Platform> Platforms add(T ... platform) throws PlatformAlreadyExistsException, PlatformInitializeException {
        return this.add((Collection<T>)Arrays.asList(platform));
    }

    private <T extends Platform> Platforms add(Collection<T> platform) throws PlatformAlreadyExistsException, PlatformInitializeException {
        this.logger.trace("invoked 'add()' platform [count={}]", (Object)platform.size());
        for (Platform platformInstance : platform) {
            this.logger.info("adding platform to managed platform map [id={}; name={}; priority={}; class={}]", platformInstance.id(), platformInstance.name(), platformInstance.priority(), platformInstance.getClass().getName());
            if (!platformInstance.enabled(this.runtime.context())) {
                this.logger.trace("not adding platform [id={}; name={}; class={}] as it reports as [DISABLED] on this system;", platformInstance.id(), platformInstance.name(), platformInstance.getClass().getName());
                continue;
            }
            if (this.exists(platformInstance.id())) {
                throw new PlatformAlreadyExistsException(platformInstance.id());
            }
            this.initializePlatform(platformInstance);
            this.platforms.put(platformInstance.id(), platformInstance);
            if (this.defaultPlatform == null) {
                this.defaultPlatform = platformInstance;
                this.logger.debug("default platform is now [id={}; name={}; class={}]", this.defaultPlatform.id(), this.defaultPlatform.name(), this.defaultPlatform.getClass().getName());
                continue;
            }
            if (platformInstance.priority() <= this.defaultPlatform.priority()) continue;
            this.defaultPlatform = platformInstance;
            this.logger.debug("default platform is now [id={}; name={}; class={}; weight={}]", this.defaultPlatform.id(), this.defaultPlatform.name(), this.defaultPlatform.getClass().getName(), this.defaultPlatform.priority());
        }
        return this;
    }

    private <T extends Platform> void remove(String platformId) throws PlatformNotFoundException, ShutdownException {
        this.logger.trace("invoked 'remove() platform' [id={}]", (Object)platformId);
        if (!this.platforms.containsKey(platformId)) {
            this.logger.warn("unable to remove platform [id={}]; id not found in managed platform map.", (Object)platformId);
            throw new PlatformNotFoundException(platformId);
        }
        Platform oldPlatform = this.platforms.get(platformId);
        this.shutdownPlatform(oldPlatform);
        Platform removedPlatform = this.platforms.remove(platformId);
        if (removedPlatform != null) {
            this.logger.debug("removed platform from managed platform map [id={}; name={}; class={}]", removedPlatform.id(), removedPlatform.name(), removedPlatform.getClass().getName());
        }
    }

    private void initializePlatform(Platform platform) throws PlatformInitializeException {
        if (platform == null) {
            return;
        }
        try {
            this.logger.trace("calling 'initialize' platform [id={}; name={}; class={}]", platform.id(), platform.name(), platform.getClass().getName());
            platform.initialize(this.runtime.context());
        }
        catch (Exception e) {
            this.logger.error("unable to 'initialize()' platform: [id={}; name={}]; {}", platform.id(), platform.name(), e.getMessage());
            this.logger.error(e.getMessage(), e);
            throw new PlatformInitializeException(platform.id(), e);
        }
    }

    private void shutdownPlatform(Platform platform) throws ShutdownException {
        if (platform == null) {
            return;
        }
        try {
            this.logger.trace("calling 'shutdown' platform [id={}; name={}; class={}]", platform.id(), platform.name(), platform.getClass().getName());
            platform.shutdown(this.runtime.context());
        }
        catch (Exception e) {
            this.logger.error("unable to 'shutdown()' platform: [id={}; name={}]; {}", platform.id(), platform.name(), e.getMessage());
            this.logger.error(e.getMessage(), e);
            throw new ShutdownException(e.getMessage(), e);
        }
    }
}

