/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.pigpio.test;

import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.library.pigpio.PiGpioException;
import com.pi4j.library.pigpio.PiGpioMode;
import com.pi4j.library.pigpio.PiGpioPud;
import com.pi4j.library.pigpio.PiGpioStateChangeEvent;
import com.pi4j.library.pigpio.PiGpioStateChangeListener;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestGpioAlert {
    private static final Logger logger = LoggerFactory.getLogger(TestGpioAlert.class);
    public static int GPIO_PIN = 21;

    public static void main(String[] args) throws IOException {
        String loglevel = "INFO";
        if (args != null && args.length > 0) {
            Level lvl = Level.valueOf(args[0].toUpperCase());
            loglevel = lvl.name();
        }
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", loglevel);
        logger.info("");
        logger.info("");
        PiGpio piGpio = PiGpio.newNativeInstance();
        piGpio.gpioInitialise();
        logger.info("-----------------------------------------------------");
        logger.info("PIGPIO INITIALIZED SUCCESSFULLY");
        logger.info("-----------------------------------------------------");
        logger.info("PIGPIO VERSION   : " + piGpio.gpioVersion());
        logger.info("PIGPIO HARDWARE  : " + piGpio.gpioHardwareRevision());
        piGpio.gpioSetMode(GPIO_PIN, PiGpioMode.INPUT);
        piGpio.gpioSetPullUpDown(GPIO_PIN, PiGpioPud.DOWN);
        piGpio.gpioGlitchFilter(GPIO_PIN, 1000);
        piGpio.addPinListener(GPIO_PIN, new PiGpioStateChangeListener(){

            @Override
            public void onChange(PiGpioStateChangeEvent event) {
                logger.info("RECEIVED ALERT EVENT! " + String.valueOf(event));
                throw new PiGpioException("TEST");
            }
        });
        System.in.read();
        logger.info("PIGPIO ALERT CALLBACK REMOVED");
        piGpio.removeAllPinListeners();
        System.in.read();
        logger.info("-----------------------------------------------------");
        piGpio.gpioTerminate();
        logger.info("PIGPIO TERMINATED");
        logger.info("-----------------------------------------------------");
        logger.info("");
        logger.info("");
    }
}

