/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.pigpio;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public interface PiGpio_SPI {
    public int spiOpen(int var1, int var2, int var3);

    default public int spiOpen(int channel, int baud) {
        return this.spiOpen(channel, baud, 0);
    }

    public int spiClose(int var1);

    default public int spiWriteByte(int handle, byte value) {
        byte[] temp = new byte[]{value};
        return this.spiWrite(handle, temp);
    }

    default public int spiReadByte(int handle) {
        byte[] temp = new byte[1];
        int result = this.spiRead(handle, temp);
        if (result <= 0) {
            return result;
        }
        return Byte.toUnsignedInt(temp[0]);
    }

    default public int spiXferByte(int handle, byte value) {
        byte[] temp = new byte[]{value};
        int result = this.spiXfer(handle, temp);
        if (result <= 0) {
            return result;
        }
        return Byte.toUnsignedInt(temp[0]);
    }

    public int spiWrite(int var1, byte[] var2, int var3, int var4);

    default public int spiWrite(int handle, byte[] data, int length) {
        return this.spiWrite(handle, data, 0, length);
    }

    default public int spiWrite(int handle, byte[] data) {
        return this.spiWrite(handle, data, 0, data.length);
    }

    default public int spiWrite(int handle, ByteBuffer buffer, int offset, int length) {
        if (length > buffer.capacity() - offset) {
            length = buffer.capacity() - offset;
        }
        return this.spiWrite(handle, buffer.array(), offset, length);
    }

    default public int spiWrite(int handle, ByteBuffer buffer, int length) {
        if (buffer.position() == buffer.limit()) {
            buffer.flip();
        }
        if (length > buffer.remaining()) {
            length = buffer.remaining();
        }
        return this.spiWrite(handle, buffer, buffer.position(), length);
    }

    default public int spiWrite(int handle, ByteBuffer buffer) {
        if (buffer.position() == buffer.limit()) {
            buffer.flip();
        }
        return this.spiWrite(handle, buffer, buffer.position(), buffer.remaining());
    }

    default public int spiWrite(int handle, Charset charset, CharSequence data, int offset, int length) {
        return this.spiWrite(handle, data.toString().getBytes(charset), offset, length);
    }

    default public int spiWrite(int handle, Charset charset, CharSequence data, int length) {
        return this.spiWrite(handle, charset, data, 0, length);
    }

    default public int spiWrite(int handle, CharSequence data, Charset charset) {
        return this.spiWrite(handle, charset, data, 0, data.length());
    }

    default public int spiWrite(int handle, CharSequence data, int offset, int length) {
        return this.spiWrite(handle, StandardCharsets.US_ASCII, data, offset, length);
    }

    default public int spiWrite(int handle, CharSequence data, int length) {
        return this.spiWrite(handle, data, 0, length);
    }

    default public int spiWrite(int handle, CharSequence data) {
        return this.spiWrite(handle, data, data.length());
    }

    public int spiRead(int var1, byte[] var2, int var3, int var4);

    default public int spiRead(int handle, byte[] buffer, int length) {
        return this.spiRead(handle, buffer, 0, length);
    }

    default public int spiRead(int handle, byte[] buffer) {
        return this.spiRead(handle, buffer, 0, buffer.length);
    }

    default public int spiRead(int handle, ByteBuffer buffer, int offset, int length) {
        byte[] temp;
        int actualLength;
        if (length > buffer.capacity() - offset) {
            length = buffer.capacity() - offset;
        }
        if ((actualLength = this.spiRead(handle, temp = new byte[length], 0, length)) < 0) {
            return actualLength;
        }
        if (actualLength < length) {
            length = actualLength;
        }
        buffer.position(offset);
        buffer.put(temp, 0, length);
        return length;
    }

    default public int spiRead(int handle, ByteBuffer buffer, int length) {
        if (buffer.position() == buffer.limit()) {
            buffer.rewind();
        }
        if (length > buffer.remaining()) {
            length = buffer.remaining();
        }
        return this.spiRead(handle, buffer, buffer.position(), length);
    }

    default public int spiRead(int handle, ByteBuffer buffer) {
        if (buffer.position() == buffer.limit()) {
            buffer.rewind();
        }
        return this.spiRead(handle, buffer, buffer.position(), buffer.remaining());
    }

    public int spiXfer(int var1, byte[] var2, int var3, byte[] var4, int var5, int var6);

    default public int spiXfer(int handle, byte[] write, byte[] read, int numberOfBytes) {
        return this.spiXfer(handle, write, 0, read, 0, numberOfBytes);
    }

    default public int spiXfer(int handle, byte[] write, byte[] read) {
        return this.spiXfer(handle, write, 0, read, 0, write.length);
    }

    default public int spiXfer(int handle, byte[] buffer, int offset, int length) {
        return this.spiXfer(handle, buffer, offset, buffer, offset, length);
    }

    default public int spiXfer(int handle, byte[] buffer, int length) {
        return this.spiXfer(handle, buffer, 0, length);
    }

    default public int spiXfer(int handle, byte[] buffer) {
        return this.spiXfer(handle, buffer, 0, buffer.length);
    }

    default public int spiXfer(int handle, ByteBuffer write, int writeOffset, ByteBuffer read, int readOffset, int numberOfBytes) {
        if (numberOfBytes > write.capacity() - writeOffset) {
            numberOfBytes = write.capacity() - writeOffset;
        }
        byte[] temp = new byte[numberOfBytes];
        int actualLength = this.spiXfer(handle, write.array(), 0, temp, 0, numberOfBytes);
        if (actualLength < 0) {
            return actualLength;
        }
        if (actualLength < numberOfBytes) {
            numberOfBytes = actualLength;
        }
        read.position(readOffset);
        read.put(temp, 0, numberOfBytes);
        return numberOfBytes;
    }

    default public int spiXfer(int handle, ByteBuffer write, ByteBuffer read, int numberOfBytes) {
        if (write.position() == write.limit()) {
            write.flip();
        }
        if (read.position() == read.limit()) {
            read.rewind();
        }
        if (numberOfBytes > write.remaining()) {
            numberOfBytes = write.remaining();
        }
        return this.spiXfer(handle, write, write.position(), read, read.position(), numberOfBytes);
    }

    default public int spiXfer(int handle, ByteBuffer buffer, int offset, int length) {
        if (length > buffer.capacity() - offset) {
            length = buffer.capacity() - offset;
        }
        byte[] temp = new byte[length];
        int actualLength = this.spiXfer(handle, buffer.array(), 0, temp, 0, length);
        if (actualLength < 0) {
            return actualLength;
        }
        if (actualLength < length) {
            length = actualLength;
        }
        buffer.position(offset);
        buffer.put(temp, 0, length);
        return length;
    }
}

