/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.pigpio;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public interface PiGpio_I2C {
    public int i2cOpen(int var1, int var2, int var3);

    default public int i2cOpen(int bus, int device) {
        return this.i2cOpen(bus, device, 0);
    }

    public int i2cClose(int var1);

    public int i2cWriteQuick(int var1, boolean var2);

    public int i2cWriteByte(int var1, byte var2);

    public int i2cReadByte(int var1);

    public int i2cWriteByteData(int var1, int var2, byte var3);

    public int i2cWriteWordData(int var1, int var2, int var3);

    public int i2cReadByteData(int var1, int var2);

    public int i2cReadWordData(int var1, int var2);

    public int i2cProcessCall(int var1, int var2, int var3);

    public int i2cWriteBlockData(int var1, int var2, byte[] var3, int var4, int var5);

    default public int i2cWriteBlockData(int handle, int register, byte[] data, int length) {
        return this.i2cWriteBlockData(handle, register, data, 0, length);
    }

    default public int i2cWriteBlockData(int handle, int register, byte[] data) {
        return this.i2cWriteBlockData(handle, register, data, data.length);
    }

    default public int i2cWriteBlockData(int handle, int register, ByteBuffer buffer, int offset, int length) {
        if (length > buffer.capacity() - offset) {
            length = buffer.capacity() - offset;
        }
        return this.i2cWriteBlockData(handle, register, buffer.array(), offset, length);
    }

    default public int i2cWriteBlockData(int handle, int register, ByteBuffer buffer, int length) {
        if (buffer.position() == buffer.limit()) {
            buffer.flip();
        }
        if (length > buffer.remaining()) {
            length = buffer.remaining();
        }
        return this.i2cWriteBlockData(handle, register, buffer, buffer.position(), length);
    }

    default public int i2cWriteBlockData(int handle, int register, ByteBuffer buffer) {
        if (buffer.position() == buffer.limit()) {
            buffer.flip();
        }
        return this.i2cWriteBlockData(handle, register, buffer, buffer.position(), buffer.remaining());
    }

    default public int i2cWriteBlockData(int handle, int register, Charset charset, CharSequence data, int offset, int length) {
        return this.i2cWriteBlockData(handle, register, data.toString().getBytes(charset), offset, length);
    }

    default public int i2cWriteBlockData(int handle, int register, Charset charset, CharSequence data, int length) {
        return this.i2cWriteBlockData(handle, register, charset, data, 0, length);
    }

    default public int i2cWriteBlockData(int handle, int register, Charset charset, CharSequence data) {
        return this.i2cWriteBlockData(handle, register, charset, data, data.length());
    }

    default public int i2cWriteBlockData(int handle, int register, CharSequence data, int offset, int length) {
        return this.i2cWriteBlockData(handle, register, StandardCharsets.US_ASCII, data, offset, length);
    }

    default public int i2cWriteBlockData(int handle, int register, CharSequence data, int length) {
        return this.i2cWriteBlockData(handle, register, data, 0, length);
    }

    default public int i2cWriteBlockData(int handle, int register, CharSequence data) {
        return this.i2cWriteBlockData(handle, register, data, data.length());
    }

    public int i2cReadBlockData(int var1, int var2, byte[] var3, int var4, int var5);

    default public int i2cReadBlockData(int handle, int register, byte[] buffer, int length) {
        return this.i2cReadBlockData(handle, register, buffer, 0, length);
    }

    default public int i2cReadBlockData(int handle, int register, byte[] buffer) {
        return this.i2cReadBlockData(handle, register, buffer, buffer.length);
    }

    default public int i2cReadBlockData(int handle, int register, ByteBuffer buffer, int offset, int length) {
        byte[] temp;
        int actualLength;
        if (length > buffer.capacity() - offset) {
            length = buffer.capacity() - offset;
        }
        if ((actualLength = this.i2cReadBlockData(handle, register, temp = new byte[length], 0, length)) < 0) {
            return actualLength;
        }
        if (actualLength < length) {
            length = actualLength;
        }
        buffer.position(offset);
        buffer.put(temp, 0, length);
        return length;
    }

    default public int i2cReadBlockData(int handle, int register, ByteBuffer buffer, int length) {
        if (buffer.position() == buffer.limit()) {
            buffer.rewind();
        }
        if (length > buffer.remaining()) {
            length = buffer.remaining();
        }
        return this.i2cReadBlockData(handle, register, buffer, buffer.position(), length);
    }

    default public int i2cReadBlockData(int handle, int register, ByteBuffer buffer) {
        if (buffer.position() == buffer.limit()) {
            buffer.rewind();
        }
        return this.i2cReadBlockData(handle, register, buffer, buffer.position(), buffer.remaining());
    }

    public int i2cBlockProcessCall(int var1, int var2, byte[] var3, int var4, int var5, byte[] var6, int var7);

    default public int i2cBlockProcessCall(int handle, int register, byte[] write, int writeOffset, int writeLength, byte[] read) {
        return this.i2cBlockProcessCall(handle, register, write, writeOffset, writeLength, read, 0);
    }

    default public int i2cBlockProcessCall(int handle, int register, byte[] write, int writeLength, byte[] read) {
        return this.i2cBlockProcessCall(handle, register, write, 0, writeLength, read, 0);
    }

    default public int i2cBlockProcessCall(int handle, int register, byte[] write, byte[] read) {
        return this.i2cBlockProcessCall(handle, register, write, 0, write.length, read, 0);
    }

    public int i2cBlockProcessCall(int var1, int var2, byte[] var3, int var4, int var5);

    default public int i2cBlockProcessCall(int handle, int register, byte[] data, int length) {
        return this.i2cBlockProcessCall(handle, register, data, 0, length);
    }

    default public int i2cBlockProcessCall(int handle, int register, byte[] data) {
        return this.i2cBlockProcessCall(handle, register, data, data.length);
    }

    public int i2cReadI2CBlockData(int var1, int var2, byte[] var3, int var4, int var5);

    default public int i2cReadI2CBlockData(int handle, int register, byte[] buffer, int length) {
        return this.i2cReadI2CBlockData(handle, register, buffer, 0, length);
    }

    default public int i2cReadI2CBlockData(int handle, int register, byte[] buffer) {
        return this.i2cReadI2CBlockData(handle, register, buffer, buffer.length);
    }

    default public int i2cReadI2CBlockData(int handle, int register, ByteBuffer buffer, int offset, int length) {
        byte[] temp;
        int actualLength;
        if (length > buffer.capacity() - offset) {
            length = buffer.capacity() - offset;
        }
        if ((actualLength = this.i2cReadI2CBlockData(handle, register, temp = new byte[length], 0, length)) < 0) {
            return actualLength;
        }
        if (actualLength < length) {
            length = actualLength;
        }
        buffer.position(offset);
        buffer.put(temp, 0, length);
        return length;
    }

    default public int i2cReadI2CBlockData(int handle, int register, ByteBuffer buffer, int length) {
        if (buffer.position() == buffer.limit()) {
            buffer.rewind();
        }
        if (length > buffer.remaining()) {
            length = buffer.remaining();
        }
        return this.i2cReadI2CBlockData(handle, register, buffer, buffer.position(), length);
    }

    default public int i2cReadI2CBlockData(int handle, int register, ByteBuffer buffer) {
        if (buffer.position() == buffer.limit()) {
            buffer.rewind();
        }
        return this.i2cReadI2CBlockData(handle, register, buffer, buffer.position(), buffer.remaining());
    }

    public int i2cWriteI2CBlockData(int var1, int var2, byte[] var3, int var4, int var5);

    default public int i2cWriteI2CBlockData(int handle, int register, byte[] data, int length) {
        return this.i2cWriteI2CBlockData(handle, register, data, 0, length);
    }

    default public int i2cWriteI2CBlockData(int handle, int register, byte[] data) {
        return this.i2cWriteI2CBlockData(handle, register, data, data.length);
    }

    default public int i2cWriteI2CBlockData(int handle, int register, ByteBuffer buffer, int offset, int length) {
        if (length > buffer.capacity() - offset) {
            length = buffer.capacity() - offset;
        }
        return this.i2cWriteI2CBlockData(handle, register, buffer.array(), offset, length);
    }

    default public int i2cWriteI2CBlockData(int handle, int register, ByteBuffer buffer, int length) {
        if (buffer.position() == buffer.limit()) {
            buffer.flip();
        }
        if (length > buffer.remaining()) {
            length = buffer.remaining();
        }
        return this.i2cWriteI2CBlockData(handle, register, buffer, buffer.position(), length);
    }

    default public int i2cWriteI2CBlockData(int handle, int register, ByteBuffer buffer) {
        if (buffer.position() == buffer.limit()) {
            buffer.flip();
        }
        return this.i2cWriteI2CBlockData(handle, register, buffer, buffer.position(), buffer.remaining());
    }

    default public int i2cWriteI2CBlockData(int handle, int register, Charset charset, CharSequence data, int offset, int length) {
        return this.i2cWriteI2CBlockData(handle, register, data.toString().getBytes(charset), offset, length);
    }

    default public int i2cWriteI2CBlockData(int handle, int register, Charset charset, CharSequence data, int length) {
        return this.i2cWriteI2CBlockData(handle, register, charset, data, 0, length);
    }

    default public int i2cWriteI2CBlockData(int handle, int register, Charset charset, CharSequence data) {
        return this.i2cWriteI2CBlockData(handle, register, charset, data, data.length());
    }

    default public int i2cWriteI2CBlockData(int handle, int register, CharSequence data, int offset, int length) {
        return this.i2cWriteI2CBlockData(handle, register, StandardCharsets.US_ASCII, data, offset, length);
    }

    default public int i2cWriteI2CBlockData(int handle, int register, CharSequence data, int length) {
        return this.i2cWriteI2CBlockData(handle, register, data, 0, length);
    }

    default public int i2cWriteI2CBlockData(int handle, int register, CharSequence data) {
        return this.i2cWriteI2CBlockData(handle, register, data, data.length());
    }

    public int i2cReadDevice(int var1, byte[] var2, int var3, int var4);

    default public int i2cReadDevice(int handle, byte[] buffer, int length) {
        return this.i2cReadDevice(handle, buffer, 0, length);
    }

    default public int i2cReadDevice(int handle, byte[] buffer) {
        return this.i2cReadDevice(handle, buffer, buffer.length);
    }

    default public int i2cReadDevice(int handle, ByteBuffer buffer, int offset, int length) {
        byte[] temp;
        int actualLength;
        if (length > buffer.capacity() - offset) {
            length = buffer.capacity() - offset;
        }
        if ((actualLength = this.i2cReadDevice(handle, temp = new byte[length], 0, length)) < 0) {
            return actualLength;
        }
        if (actualLength < length) {
            length = actualLength;
        }
        buffer.position(offset);
        buffer.put(temp, 0, length);
        return length;
    }

    default public int i2cReadDevice(int handle, ByteBuffer buffer, int length) {
        if (buffer.position() == buffer.limit()) {
            buffer.rewind();
        }
        if (length > buffer.remaining()) {
            length = buffer.remaining();
        }
        return this.i2cReadDevice(handle, buffer, buffer.position(), length);
    }

    default public int i2cReadDevice(int handle, ByteBuffer buffer) {
        if (buffer.position() == buffer.limit()) {
            buffer.rewind();
        }
        return this.i2cReadDevice(handle, buffer, buffer.position(), buffer.remaining());
    }

    public int i2cWriteDevice(int var1, byte[] var2, int var3, int var4);

    default public int i2cWriteDevice(int handle, byte[] data, int length) {
        return this.i2cWriteDevice(handle, data, 0, length);
    }

    default public int i2cWriteDevice(int handle, byte[] data) {
        return this.i2cWriteDevice(handle, data, data.length);
    }

    default public int i2cWriteDevice(int handle, ByteBuffer buffer, int offset, int length) {
        if (length > buffer.capacity() - offset) {
            length = buffer.capacity() - offset;
        }
        return this.i2cWriteDevice(handle, buffer.array(), offset, length);
    }

    default public int i2cWriteDevice(int handle, ByteBuffer buffer, int length) {
        if (buffer.position() == buffer.limit()) {
            buffer.flip();
        }
        if (length > buffer.remaining()) {
            length = buffer.remaining();
        }
        return this.i2cWriteDevice(handle, buffer, buffer.position(), length);
    }

    default public int i2cWriteDevice(int handle, ByteBuffer buffer) {
        if (buffer.position() == buffer.limit()) {
            buffer.flip();
        }
        return this.i2cWriteDevice(handle, buffer, buffer.position(), buffer.remaining());
    }

    default public int i2cWriteDevice(int handle, Charset charset, CharSequence data, int offset, int length) {
        return this.i2cWriteDevice(handle, data.toString().getBytes(charset), offset, length);
    }

    default public int i2cWriteDevice(int handle, Charset charset, CharSequence data, int length) {
        return this.i2cWriteDevice(handle, charset, data, 0, length);
    }

    default public int i2cWriteDevice(int handle, Charset charset, CharSequence data) {
        return this.i2cWriteDevice(handle, charset, data, data.length());
    }

    default public int i2cWriteDevice(int handle, CharSequence data, int offset, int length) {
        return this.i2cWriteDevice(handle, data.toString().getBytes(StandardCharsets.US_ASCII), offset, length);
    }

    default public int i2cWriteDevice(int handle, CharSequence data, int length) {
        return this.i2cWriteDevice(handle, data, 0, length);
    }

    default public int i2cWriteDevice(int handle, CharSequence data) {
        return this.i2cWriteDevice(handle, data, data.length());
    }
}

