/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.pigpio;

public enum PiGpioError {
    UNKNOWN(0),
    PI_INIT_FAILED(-1),
    PI_BAD_USER_GPIO(-2),
    PI_BAD_GPIO(-3),
    PI_BAD_MODE(-4),
    PI_BAD_LEVEL(-5),
    PI_BAD_PUD(-6),
    PI_BAD_PULSEWIDTH(-7),
    PI_BAD_DUTYCYCLE(-8),
    PI_BAD_TIMER(-9),
    PI_BAD_MS(-10),
    PI_BAD_TIMETYPE(-11),
    PI_BAD_SECONDS(-12),
    PI_BAD_MICROS(-13),
    PI_TIMER_FAILED(-14),
    PI_BAD_WDOG_TIMEOUT(-15),
    PI_NO_ALERT_FUNC(-16),
    PI_BAD_CLK_PERIPH(-17),
    PI_BAD_CLK_SOURCE(-18),
    PI_BAD_CLK_MICROS(-19),
    PI_BAD_BUF_MILLIS(-20),
    PI_BAD_DUTYRANGE(-21),
    PI_BAD_DUTY_RANGE(-21),
    PI_BAD_SIGNUM(-22),
    PI_BAD_PATHNAME(-23),
    PI_NO_HANDLE(-24),
    PI_BAD_HANDLE(-25),
    PI_BAD_IF_FLAGS(-26),
    PI_BAD_CHANNEL(-27),
    PI_BAD_PRIM_CHANNEL(-27),
    PI_BAD_SOCKET_PORT(-28),
    PI_BAD_FIFO_COMMAND(-29),
    PI_BAD_SECO_CHANNEL(-30),
    PI_NOT_INITIALISED(-31),
    PI_INITIALISED(-32),
    PI_BAD_WAVE_MODE(-33),
    PI_BAD_CFG_INTERNAL(-34),
    PI_BAD_WAVE_BAUD(-35),
    PI_TOO_MANY_PULSES(-36),
    PI_TOO_MANY_CHARS(-37),
    PI_NOT_SERIAL_GPIO(-38),
    PI_BAD_SERIAL_STRUC(-39),
    PI_BAD_SERIAL_BUF(-40),
    PI_NOT_PERMITTED(-41),
    PI_SOME_PERMITTED(-42),
    PI_BAD_WVSC_COMMND(-43),
    PI_BAD_WVSM_COMMND(-44),
    PI_BAD_WVSP_COMMND(-45),
    PI_BAD_PULSELEN(-46),
    PI_BAD_SCRIPT(-47),
    PI_BAD_SCRIPT_ID(-48),
    PI_BAD_SER_OFFSET(-49),
    PI_GPIO_IN_USE(-50),
    PI_BAD_SERIAL_COUNT(-51),
    PI_BAD_PARAM_NUM(-52),
    PI_DUP_TAG(-53),
    PI_TOO_MANY_TAGS(-54),
    PI_BAD_SCRIPT_CMD(-55),
    PI_BAD_VAR_NUM(-56),
    PI_NO_SCRIPT_ROOM(-57),
    PI_NO_MEMORY(-58),
    PI_SOCK_READ_FAILED(-59),
    PI_SOCK_WRIT_FAILED(-60),
    PI_TOO_MANY_PARAM(-61),
    PI_NOT_HALTED(-62),
    PI_SCRIPT_NOT_READY(-62),
    PI_BAD_TAG(-63),
    PI_BAD_MICS_DELAY(-64),
    PI_BAD_MILS_DELAY(-65),
    PI_BAD_WAVE_ID(-66),
    PI_TOO_MANY_CBS(-67),
    PI_TOO_MANY_OOL(-68),
    PI_EMPTY_WAVEFORM(-69),
    PI_NO_WAVEFORM_ID(-70),
    PI_I2C_OPEN_FAILED(-71),
    PI_SER_OPEN_FAILED(-72),
    PI_SPI_OPEN_FAILED(-73),
    PI_BAD_I2C_BUS(-74),
    PI_BAD_I2C_ADDR(-75),
    PI_BAD_SPI_CHANNEL(-76),
    PI_BAD_FLAGS(-77),
    PI_BAD_SPI_SPEED(-78),
    PI_BAD_SER_DEVICE(-79),
    PI_BAD_SER_SPEED(-80),
    PI_BAD_PARAM(-81),
    PI_I2C_WRITE_FAILED(-82),
    PI_I2C_READ_FAILED(-83),
    PI_BAD_SPI_COUNT(-84),
    PI_SER_WRITE_FAILED(-85),
    PI_SER_READ_FAILED(-86),
    PI_SER_READ_NO_DATA(-87),
    PI_UNKNOWN_COMMAND(-88),
    PI_SPI_XFER_FAILED(-89),
    PI_BAD_POINTER(-90),
    PI_NO_AUX_SPI(-91),
    PI_NOT_PWM_GPIO(-92),
    PI_NOT_SERVO_GPIO(-93),
    PI_NOT_HCLK_GPIO(-94),
    PI_NOT_HPWM_GPIO(-95),
    PI_BAD_HPWM_FREQ(-96),
    PI_BAD_HPWM_DUTY(-97),
    PI_BAD_HCLK_FREQ(-98),
    PI_BAD_HCLK_PASS(-99),
    PI_HPWM_ILLEGAL(-100),
    PI_BAD_DATABITS(-101),
    PI_BAD_STOPBITS(-102),
    PI_MSG_TOOBIG(-103),
    PI_BAD_MALLOC_MODE(-104),
    PI_TOO_MANY_SEGS(-105),
    PI_BAD_I2C_SEG(-106),
    PI_BAD_SMBUS_CMD(-107),
    PI_NOT_I2C_GPIO(-108),
    PI_BAD_I2C_WLEN(-109),
    PI_BAD_I2C_RLEN(-110),
    PI_BAD_I2C_CMD(-111),
    PI_BAD_I2C_BAUD(-112),
    PI_CHAIN_LOOP_CNT(-113),
    PI_BAD_CHAIN_LOOP(-114),
    PI_CHAIN_COUNTER(-115),
    PI_BAD_CHAIN_CMD(-116),
    PI_BAD_CHAIN_DELAY(-117),
    PI_CHAIN_NESTING(-118),
    PI_CHAIN_TOO_BIG(-119),
    PI_DEPRECATED(-120),
    PI_BAD_SER_INVERT(-121),
    PI_BAD_EDGE(-122),
    PI_BAD_ISR_INIT(-123),
    PI_BAD_FOREVER(-124),
    PI_BAD_FILTER(-125),
    PI_BAD_PAD(-126),
    PI_BAD_STRENGTH(-127),
    PI_FIL_OPEN_FAILED(-128),
    PI_BAD_FILE_MODE(-129),
    PI_BAD_FILE_FLAG(-130),
    PI_BAD_FILE_READ(-131),
    PI_BAD_FILE_WRITE(-132),
    PI_FILE_NOT_ROPEN(-133),
    PI_FILE_NOT_WOPEN(-134),
    PI_BAD_FILE_SEEK(-135),
    PI_NO_FILE_MATCH(-136),
    PI_NO_FILE_ACCESS(-137),
    PI_FILE_IS_A_DIR(-138),
    PI_BAD_SHELL_STATUS(-139),
    PI_BAD_SCRIPT_NAME(-140),
    PI_BAD_SPI_BAUD(-141),
    PI_NOT_SPI_GPIO(-142),
    PI_BAD_EVENT_ID(-143),
    PI_CMD_INTERRUPTED(-144),
    PI_NOT_ON_BCM2711(-145),
    PI_ONLY_ON_BCM2711(-146),
    PI_PIGIF_ERR_0(-2000),
    PI_PIGIF_ERR_99(-2099),
    PI_CUSTOM_ERR_0(-3000),
    PI_CUSTOM_ERR_999(-3999);

    private int value;

    private PiGpioError(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public String message() {
        switch (this.ordinal()) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "pigpio initialisation failed";
            }
            case 2: {
                return "GPIO not 0-31";
            }
            case 3: {
                return "GPIO not 0-53";
            }
            case 4: {
                return "mode not 0-7";
            }
            case 5: {
                return "level not 0-1";
            }
            case 6: {
                return "pud not 0-2";
            }
            case 7: {
                return "pulsewidth not 0 or 500-2500";
            }
            case 8: {
                return "dutycycle not 0-range (default 255)";
            }
            case 9: {
                return "timer not 0-9";
            }
            case 10: {
                return "ms not 10-60000";
            }
            case 11: {
                return "timetype not 0-1";
            }
            case 12: {
                return "seconds < 0";
            }
            case 13: {
                return "micros not 0-999999";
            }
            case 14: {
                return "gpioSetTimerFunc failed";
            }
            case 15: {
                return "timeout not 0-60000";
            }
            case 16: {
                return "DEPRECATED";
            }
            case 17: {
                return "clock peripheral not 0-1";
            }
            case 18: {
                return "DEPRECATED";
            }
            case 19: {
                return "clock micros not 1: return 2: return 4: return 5: return 8: return or 10";
            }
            case 20: {
                return "buf millis not 100-10000";
            }
            case 21: {
                return "dutycycle range not 25-40000";
            }
            case 23: {
                return "signum not 0-63";
            }
            case 24: {
                return "can't open pathname";
            }
            case 25: {
                return "no handle available";
            }
            case 26: {
                return "unknown handle";
            }
            case 27: {
                return "ifFlags > 4";
            }
            case 28: {
                return "DMA channel not 0-14";
            }
            case 30: {
                return "socket port not 1024-30000";
            }
            case 31: {
                return "unknown fifo command";
            }
            case 32: {
                return "DMA secondary channel not 0-14";
            }
            case 33: {
                return "function called before gpioInitialise";
            }
            case 34: {
                return "function called after gpioInitialise";
            }
            case 35: {
                return "waveform mode not 0-1";
            }
            case 36: {
                return "bad parameter in gpioCfgInternals call";
            }
            case 37: {
                return "baud rate not 50-250K(RX)/50-1M(TX)";
            }
            case 38: {
                return "waveform has too many pulses";
            }
            case 39: {
                return "waveform has too many chars";
            }
            case 40: {
                return "no bit bang serial read in progress on GPIO";
            }
            case 41: {
                return "bad (null) serial structure parameter";
            }
            case 42: {
                return "bad (null) serial buf parameter";
            }
            case 43: {
                return "no permission to update GPIO";
            }
            case 44: {
                return "no permission to update one or more GPIO";
            }
            case 45: {
                return "bad WVSC subcommand";
            }
            case 46: {
                return "bad WVSM subcommand";
            }
            case 47: {
                return "bad WVSP subcommand";
            }
            case 48: {
                return "trigger pulse length not 1-100";
            }
            case 49: {
                return "invalid script";
            }
            case 50: {
                return "unknown script id";
            }
            case 51: {
                return "add serial data offset > 30 minute";
            }
            case 52: {
                return "GPIO already in use";
            }
            case 53: {
                return "must read at least a byte at a time";
            }
            case 54: {
                return "script parameter id not 0-9";
            }
            case 55: {
                return "script has duplicate tag";
            }
            case 56: {
                return "script has too many tags";
            }
            case 57: {
                return "illegal script command";
            }
            case 58: {
                return "script variable id not 0-149";
            }
            case 59: {
                return "no more room for scripts";
            }
            case 60: {
                return "can't allocate temporary memory";
            }
            case 61: {
                return "socket read failed";
            }
            case 62: {
                return "socket write failed";
            }
            case 63: {
                return "too many script parameters (> 10)";
            }
            case 65: {
                return "script initialising";
            }
            case 66: {
                return "script has unresolved tag";
            }
            case 67: {
                return "bad MICS delay (too large)";
            }
            case 68: {
                return "bad MILS delay (too large)";
            }
            case 69: {
                return "non existent wave id";
            }
            case 70: {
                return "No more CBs for waveform";
            }
            case 71: {
                return "No more OOL for waveform";
            }
            case 72: {
                return "attempt to create an empty waveform";
            }
            case 73: {
                return "no more waveform ids";
            }
            case 74: {
                return "can't open I2C device";
            }
            case 75: {
                return "can't open serial device";
            }
            case 76: {
                return "can't open SPI device";
            }
            case 77: {
                return "bad I2C bus";
            }
            case 78: {
                return "bad I2C address";
            }
            case 79: {
                return "bad SPI channel";
            }
            case 80: {
                return "bad i2c/spi/ser open flags";
            }
            case 81: {
                return "bad SPI speed";
            }
            case 82: {
                return "bad serial device name";
            }
            case 83: {
                return "bad serial baud rate";
            }
            case 84: {
                return "bad i2c/spi/ser parameter";
            }
            case 85: {
                return "I2C write failed";
            }
            case 86: {
                return "I2C read failed";
            }
            case 87: {
                return "bad SPI count";
            }
            case 88: {
                return "ser write failed";
            }
            case 89: {
                return "ser read failed";
            }
            case 90: {
                return "ser read no data available";
            }
            case 91: {
                return "unknown command";
            }
            case 92: {
                return "spi xfer/read/write failed";
            }
            case 93: {
                return "bad (NULL) pointer";
            }
            case 94: {
                return "no auxiliary SPI on Pi A or B";
            }
            case 95: {
                return "GPIO is not in use for PWM";
            }
            case 96: {
                return "GPIO is not in use for servo pulses";
            }
            case 97: {
                return "GPIO has no hardware clock";
            }
            case 98: {
                return "GPIO has no hardware PWM";
            }
            case 99: {
                return "invalid hardware PWM frequency";
            }
            case 100: {
                return "hardware PWM dutycycle not 0-1M";
            }
            case 101: {
                return "invalid hardware clock frequency";
            }
            case 102: {
                return "need password to use hardware clock 1";
            }
            case 103: {
                return "illegal: return PWM in use for main clock";
            }
            case 104: {
                return "serial data bits not 1-32";
            }
            case 105: {
                return "serial (half) stop bits not 2-8";
            }
            case 106: {
                return "socket/pipe message too big";
            }
            case 107: {
                return "bad memory allocation mode";
            }
            case 108: {
                return "too many I2C transaction segments";
            }
            case 109: {
                return "an I2C transaction segment failed";
            }
            case 110: {
                return "SMBus command not supported by driver";
            }
            case 111: {
                return "no bit bang I2C in progress on GPIO";
            }
            case 112: {
                return "bad I2C write length";
            }
            case 113: {
                return "bad I2C read length";
            }
            case 114: {
                return "bad I2C command";
            }
            case 115: {
                return "bad I2C baud rate: return not 50-500k";
            }
            case 116: {
                return "bad chain loop count";
            }
            case 117: {
                return "empty chain loop";
            }
            case 118: {
                return "too many chain counters";
            }
            case 119: {
                return "bad chain command";
            }
            case 120: {
                return "bad chain delay micros";
            }
            case 121: {
                return "chain counters nested too deeply";
            }
            case 122: {
                return "chain is too long";
            }
            case 123: {
                return "deprecated function removed";
            }
            case 124: {
                return "bit bang serial invert not 0 or 1";
            }
            case 125: {
                return "bad ISR edge: return not 1: return 1: return or 2";
            }
            case 126: {
                return "bad ISR initialisation";
            }
            case 127: {
                return "loop forever must be last chain command";
            }
            case 128: {
                return "bad filter parameter";
            }
            case 129: {
                return "bad pad number";
            }
            case 130: {
                return "bad pad drive strength";
            }
            case 131: {
                return "file open failed";
            }
            case 132: {
                return "bad file mode";
            }
            case 133: {
                return "bad file flag";
            }
            case 134: {
                return "bad file read";
            }
            case 135: {
                return "bad file write";
            }
            case 136: {
                return "file not open for read";
            }
            case 137: {
                return "file not open for write";
            }
            case 138: {
                return "bad file seek";
            }
            case 139: {
                return "no files match pattern";
            }
            case 140: {
                return "no permission to access file";
            }
            case 141: {
                return "file is a directory";
            }
            case 142: {
                return "bad shell return status";
            }
            case 143: {
                return "bad script name";
            }
            case 144: {
                return "bad SPI baud rate: return not 50-500k";
            }
            case 145: {
                return "no bit bang SPI in progress on GPIO";
            }
            case 146: {
                return "bad event id";
            }
            case 147: {
                return "command interrupted: return Python";
            }
            case 148: {
                return "not available on BCM2711";
            }
            case 149: {
                return "only available on BCM2711";
            }
        }
        return "Not listed";
    }

    public static PiGpioError from(Number value) {
        for (PiGpioError c : PiGpioError.values()) {
            if (c.value() != value.intValue()) continue;
            return c;
        }
        return UNKNOWN;
    }
}

