/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.spi.impl;

import com.pi4j.context.Context;
import com.pi4j.io.impl.IOAddressConfigBuilderBase;
import com.pi4j.io.spi.SpiBus;
import com.pi4j.io.spi.SpiChipSelect;
import com.pi4j.io.spi.SpiConfig;
import com.pi4j.io.spi.SpiConfigBuilder;
import com.pi4j.io.spi.SpiMode;
import com.pi4j.io.spi.impl.DefaultSpiConfig;

public class DefaultSpiConfigBuilder
extends IOAddressConfigBuilderBase<SpiConfigBuilder, SpiConfig>
implements SpiConfigBuilder {
    protected DefaultSpiConfigBuilder(Context context) {
        super(context);
    }

    public static SpiConfigBuilder newInstance(Context context) {
        return new DefaultSpiConfigBuilder(context);
    }

    @Override
    public SpiConfigBuilder baud(Integer rate) {
        this.properties.put("baud", rate.toString());
        return this;
    }

    @Override
    public SpiConfigBuilder bus(SpiBus bus) {
        this.properties.put("bus", Integer.toString(bus.getBus()));
        return this;
    }

    @Override
    public SpiConfigBuilder mode(SpiMode mode) {
        this.properties.put("mode", Integer.toString(mode.getMode()));
        return this;
    }

    @Override
    public SpiConfigBuilder flags(Long flags) {
        this.properties.put("flags", flags.toString());
        return this;
    }

    @Override
    public SpiConfigBuilder channel(Integer channel) {
        this.properties.put("address", channel.toString());
        return this;
    }

    @Override
    public SpiConfigBuilder chipSelect(SpiChipSelect chipSelect) {
        this.properties.put("address", Integer.toString(chipSelect.getChipSelect()));
        return this;
    }

    @Override
    public SpiConfig build() {
        DefaultSpiConfig config = new DefaultSpiConfig(this.properties);
        return config;
    }
}

