/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio.digital.impl;

import com.pi4j.context.Context;
import com.pi4j.io.gpio.digital.DigitalOutput;
import com.pi4j.io.gpio.digital.DigitalOutputBuilder;
import com.pi4j.io.gpio.digital.DigitalOutputConfig;
import com.pi4j.io.gpio.digital.DigitalOutputConfigBuilder;
import com.pi4j.io.gpio.digital.DigitalState;
import com.pi4j.platform.Platform;
import com.pi4j.provider.Provider;
import com.pi4j.util.StringUtil;

public class DefaultDigitalOutputBuilder
implements DigitalOutputBuilder {
    private final Context context;
    private final DigitalOutputConfigBuilder builder;
    private String platformId = null;
    private Class<? extends Platform> platformClass = null;
    private String providerId = null;
    private Class<? extends Provider> providerClass = null;

    public static DigitalOutputBuilder newInstance(Context context) {
        return new DefaultDigitalOutputBuilder(context);
    }

    protected DefaultDigitalOutputBuilder(Context context) {
        this.context = context;
        this.builder = DigitalOutputConfigBuilder.newInstance(context);
    }

    @Override
    public DigitalOutputBuilder id(String id) {
        this.builder.id(id);
        return this;
    }

    @Override
    public DigitalOutputBuilder name(String name) {
        this.builder.name(name);
        return this;
    }

    @Override
    public DigitalOutputBuilder description(String description) {
        this.builder.description(description);
        return this;
    }

    @Override
    public DigitalOutputBuilder address(Integer address) {
        this.builder.address(address);
        return this;
    }

    @Override
    public DigitalOutputBuilder shutdown(DigitalState state) {
        this.builder.shutdown(state);
        return this;
    }

    @Override
    public DigitalOutputBuilder initial(DigitalState state) {
        this.builder.initial(state);
        return this;
    }

    @Override
    public DigitalOutputBuilder platform(String platformId) {
        this.platformId = platformId;
        return this;
    }

    @Override
    public DigitalOutputBuilder platform(Class<? extends Platform> platformClass) {
        this.platformClass = platformClass;
        return this;
    }

    @Override
    public DigitalOutputBuilder provider(String providerId) {
        this.providerId = providerId;
        return this;
    }

    @Override
    public DigitalOutputBuilder provider(Class<? extends Provider> providerClass) {
        this.providerClass = providerClass;
        return this;
    }

    @Override
    public DigitalOutput build() {
        DigitalOutputConfig config = (DigitalOutputConfig)this.builder.build();
        if (StringUtil.isNotNullOrEmpty(this.providerId)) {
            return (DigitalOutput)this.context.provider(this.providerId).create((DigitalOutputConfig)config);
        }
        if (this.providerClass != null) {
            return (DigitalOutput)this.context.provider(this.providerClass).create(config);
        }
        if (StringUtil.isNotNullOrEmpty(this.platformId)) {
            return (DigitalOutput)this.context.platforms().get(this.platformId).dout().create((DigitalOutputConfig)config);
        }
        if (this.platformClass != null) {
            return (DigitalOutput)this.context.platforms().get(this.platformClass).dout().create((DigitalOutputConfig)config);
        }
        return (DigitalOutput)this.context.dout().create((DigitalOutputConfig)config);
    }
}

