/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio.digital;

import java.util.EnumSet;

public enum DigitalState {
    UNKNOWN(-1, "UNKNOWN"),
    LOW(0, "LOW"),
    HIGH(1, "HIGH");

    private final Integer value;
    private final String name;

    private DigitalState(Integer value, String name) {
        this.value = value;
        this.name = name;
    }

    public boolean isHigh() {
        return this == HIGH;
    }

    public boolean isLow() {
        return this == LOW;
    }

    public Number value() {
        return this.getValue();
    }

    public Number getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(DigitalState state) {
        return this == state;
    }

    public boolean equals(Number state) {
        return this == DigitalState.getState(state);
    }

    public boolean equals(boolean state) {
        return this == DigitalState.getState(state);
    }

    public boolean equals(byte state) {
        return this.equals(DigitalState.getState(state));
    }

    public boolean equals(short state) {
        return this.equals(DigitalState.getState(state));
    }

    public boolean equals(int state) {
        return this.equals(DigitalState.getState(state));
    }

    public boolean equals(long state) {
        return this.equals(DigitalState.getState(state));
    }

    public boolean equals(float state) {
        return this.equals(DigitalState.getState(Float.valueOf(state)));
    }

    public boolean equals(double state) {
        return this.equals(DigitalState.getState(state));
    }

    public String toString() {
        return this.name;
    }

    public static DigitalState state(Number state) {
        return DigitalState.getState(state);
    }

    public static DigitalState getState(Number state) {
        for (DigitalState item : DigitalState.values()) {
            if (item.getValue().intValue() != state.intValue()) continue;
            return item;
        }
        return null;
    }

    public static DigitalState inverseState(DigitalState state) {
        return DigitalState.getInverseState(state);
    }

    public static DigitalState getInverseState(DigitalState state) {
        return state == HIGH ? LOW : HIGH;
    }

    public static DigitalState getState(boolean state) {
        return state ? HIGH : LOW;
    }

    public static DigitalState[] allStates() {
        return DigitalState.values();
    }

    public static EnumSet<DigitalState> all() {
        return EnumSet.of(HIGH, LOW);
    }

    public static DigitalState parse(String state) {
        if (state.equalsIgnoreCase("0")) {
            return LOW;
        }
        if (state.equalsIgnoreCase("1")) {
            return HIGH;
        }
        if (state.toLowerCase().startsWith("l")) {
            return LOW;
        }
        if (state.toLowerCase().startsWith("h")) {
            return HIGH;
        }
        return UNKNOWN;
    }
}

