/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio.analog.impl;

import com.pi4j.io.gpio.analog.AnalogOutputConfig;
import com.pi4j.io.gpio.analog.AnalogRange;
import com.pi4j.io.gpio.analog.impl.AnalogConfigBase;
import com.pi4j.io.gpio.analog.impl.DefaultAnalogRange;
import com.pi4j.util.StringUtil;
import java.util.Map;

public class DefaultAnalogOutputConfig
extends AnalogConfigBase<AnalogOutputConfig>
implements AnalogOutputConfig {
    protected Integer shutdownValue = null;
    protected Integer initialValue = null;
    protected Integer stepValue = null;

    private DefaultAnalogOutputConfig() {
    }

    protected DefaultAnalogOutputConfig(Map<String, String> properties) {
        super(properties);
        this.id = StringUtil.setIfNullOrEmpty(this.id, "AOUT-" + this.address, true);
        this.name = StringUtil.setIfNullOrEmpty(this.name, "AOUT-" + this.address, true);
        this.description = StringUtil.setIfNullOrEmpty(this.description, "AOUT-" + this.address, true);
        if (properties.containsKey("initial")) {
            this.initialValue = Integer.parseInt(properties.get("initial"));
        }
        if (properties.containsKey("shutdown")) {
            this.shutdownValue = Integer.parseInt(properties.get("shutdown"));
        }
        if (properties.containsKey("step")) {
            this.stepValue = Integer.parseInt(properties.get("step"));
        }
        if (properties.containsKey("min") || properties.containsKey("max")) {
            Integer min = null;
            Integer max = null;
            if (properties.containsKey("min")) {
                min = Integer.parseInt(properties.get("min"));
            }
            if (properties.containsKey("max")) {
                max = Integer.parseInt(properties.get("max"));
            }
            if (min != null || max != null) {
                this.range = new DefaultAnalogRange(min, max);
            }
        }
        if (this.stepValue == null) {
            this.stepValue = 1;
        }
    }

    @Override
    public Integer shutdownValue() {
        return this.shutdownValue;
    }

    @Override
    public DefaultAnalogOutputConfig shutdownValue(Integer value) {
        this.shutdownValue = value;
        return this;
    }

    @Override
    public Integer stepValue() {
        return this.stepValue;
    }

    @Override
    public AnalogOutputConfig stepValue(Integer value) {
        return null;
    }

    @Override
    public Integer initialValue() {
        return this.initialValue;
    }

    @Override
    public AnalogRange range() {
        return this.range;
    }
}

