/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio.analog;

import com.pi4j.context.Context;
import com.pi4j.io.exception.IOBoundsException;
import com.pi4j.io.exception.IOException;
import com.pi4j.io.exception.IOIllegalValueException;
import com.pi4j.io.gpio.analog.AnalogBase;
import com.pi4j.io.gpio.analog.AnalogOutput;
import com.pi4j.io.gpio.analog.AnalogOutputConfig;
import com.pi4j.io.gpio.analog.AnalogOutputProvider;
import com.pi4j.io.gpio.analog.AnalogValueChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnalogOutputBase
extends AnalogBase<AnalogOutput, AnalogOutputConfig, AnalogOutputProvider>
implements AnalogOutput {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Integer value = 0;

    public AnalogOutputBase(AnalogOutputProvider provider, AnalogOutputConfig config) {
        super(provider, config);
        if (this.id == null) {
            this.id = "AOUT-" + config.address();
        }
        if (this.name == null) {
            this.name = "AOUT-" + config.address();
        }
        if (((AnalogOutputConfig)this.config()).initialValue() != null) {
            try {
                this.value(((AnalogOutputConfig)this.config()).initialValue());
            }
            catch (IOBoundsException | IOIllegalValueException e) {
                this.logger.error(e.getMessage(), e);
            }
        }
    }

    @Override
    public AnalogOutput stepUp() {
        try {
            return this.step(((AnalogOutputConfig)this.config()).stepValue());
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
            return this;
        }
    }

    @Override
    public AnalogOutput stepDown() {
        try {
            return this.step(0 - ((AnalogOutputConfig)this.config()).stepValue());
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
            return this;
        }
    }

    @Override
    public AnalogOutput step(Integer value) throws IOIllegalValueException, IOBoundsException {
        if (value == null) {
            throw new IOIllegalValueException();
        }
        Integer oldValue = this.value();
        Integer newValue = value + oldValue;
        if (((AnalogOutputConfig)this.config()).range() != null) {
            newValue = ((AnalogOutputConfig)this.config()).range().sanitize(newValue);
        }
        return this.value(newValue);
    }

    @Override
    public AnalogOutput value(Integer value) throws IOIllegalValueException, IOBoundsException {
        if (value == null) {
            throw new IOIllegalValueException();
        }
        if (((AnalogOutputConfig)this.config()).range() != null && !((AnalogOutputConfig)this.config()).range().validate(value)) {
            throw new IOBoundsException(value, ((AnalogOutputConfig)this.config()).range().min(), ((AnalogOutputConfig)this.config()).range().max());
        }
        if (this.value().intValue() != value.intValue()) {
            Integer oldValue = this.value();
            this.value = value;
            this.dispatch(new AnalogValueChangeEvent<AnalogOutputBase>(this, this.value(), oldValue));
        }
        return this;
    }

    @Override
    public AnalogOutput shutdown(Context context) {
        if (((AnalogOutputConfig)this.config()).shutdownValue() != null) {
            try {
                this.value(((AnalogOutputConfig)this.config()).shutdownValue());
            }
            catch (IOBoundsException | IOIllegalValueException e) {
                this.logger.error(e.getMessage(), e);
            }
        }
        return this;
    }

    @Override
    public Integer value() {
        return this.value;
    }
}

