/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.binding.impl;

import com.pi4j.io.OnOff;
import com.pi4j.io.binding.OnOffBinding;
import com.pi4j.io.binding.impl.BindingBase;
import com.pi4j.io.exception.IOException;
import com.pi4j.io.gpio.analog.AnalogValueChangeEvent;
import com.pi4j.io.gpio.digital.DigitalStateChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOnOffBinding
extends BindingBase<OnOffBinding, OnOff>
implements OnOffBinding {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Integer onValueThreshold = 1;
    protected Integer offValueThreshold = 0;

    public DefaultOnOffBinding(OnOff ... member) {
        super(member);
    }

    @Override
    public void process(DigitalStateChangeEvent event) {
        boolean on = event.source().isOn();
        this.members.forEach(target -> {
            try {
                if (on) {
                    if (target.isOff()) {
                        target.on();
                    }
                } else if (target.isOn()) {
                    target.off();
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), e);
            }
        });
    }

    @Override
    public void process(AnalogValueChangeEvent event) {
        Boolean state = null;
        if (this.onValueThreshold == this.offValueThreshold) {
            return;
        }
        if (this.onValueThreshold > this.offValueThreshold) {
            if (event.value() >= this.onValueThreshold) {
                state = true;
            } else if (event.value() <= this.offValueThreshold) {
                state = false;
            }
        } else if (event.value() <= this.onValueThreshold) {
            state = true;
        } else if (event.value() >= this.offValueThreshold) {
            state = false;
        }
        if (state == null) {
            return;
        }
        boolean onState = state;
        this.members.forEach(target -> {
            try {
                if (onState) {
                    if (target.isOff()) {
                        target.on();
                    }
                } else if (target.isOn()) {
                    target.off();
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), e);
            }
        });
    }

    @Override
    public OnOffBinding analogValueThresholdOn(int value) {
        this.onValueThreshold = value;
        return this;
    }

    @Override
    public OnOffBinding analogValueThresholdOff(int value) {
        this.offValueThreshold = value;
        return this;
    }

    @Override
    public int analogValueThresholdOn() {
        return this.onValueThreshold;
    }

    @Override
    public int analogValueThresholdOff() {
        return this.offValueThreshold;
    }
}

