/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.context;

import com.pi4j.config.Builder;
import com.pi4j.context.Context;
import com.pi4j.context.ContextConfig;
import com.pi4j.context.impl.DefaultContextBuilder;
import com.pi4j.platform.Platform;
import com.pi4j.provider.Provider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;

public interface ContextBuilder
extends Builder<Context> {
    public static ContextBuilder newInstance() {
        return DefaultContextBuilder.newInstance();
    }

    public ContextBuilder add(Platform ... var1);

    public ContextBuilder add(Provider ... var1);

    public String defaultPlatform();

    public ContextBuilder defaultPlatform(String var1);

    public ContextBuilder autoDetectPlatforms();

    public ContextBuilder noAutoDetectPlatforms();

    public ContextBuilder autoDetectProviders();

    public ContextBuilder noAutoDetectProviders();

    public ContextBuilder autoInject();

    public ContextBuilder noAutoInject();

    default public ContextBuilder setAutoInject(boolean autoInject) {
        if (autoInject) {
            return this.autoInject();
        }
        return this.noAutoInject();
    }

    public ContextConfig toConfig();

    default public ContextBuilder setAutoDetect(boolean autoDetect) {
        if (autoDetect) {
            return this.autoDetect();
        }
        return this.noAutoDetect();
    }

    default public ContextBuilder autoDetect() {
        return this.autoDetectPlatforms().autoDetectProviders();
    }

    default public ContextBuilder noAutoDetect() {
        return this.noAutoDetectPlatforms().noAutoDetectProviders();
    }

    default public ContextBuilder addPlatform(Platform ... platform) {
        return this.add(platform);
    }

    default public ContextBuilder addPlatform(Provider ... provider) {
        return this.add(provider);
    }

    default public ContextBuilder addDefaultPlatform(Platform platform) {
        return this.add(platform).defaultPlatform(platform.id());
    }

    default public ContextBuilder defaultPlatform(Platform platform) {
        return this.defaultPlatform(platform.id());
    }

    default public ContextBuilder setDefaultPlatform(String platformId) {
        return this.defaultPlatform(platformId);
    }

    default public ContextBuilder setDefaultPlatform(Platform platform) {
        return this.defaultPlatform(platform);
    }

    public ContextBuilder property(String var1, String var2);

    public ContextBuilder property(Map.Entry<String, String> ... var1);

    public ContextBuilder properties(Map<String, String> var1);

    public ContextBuilder properties(Map<String, String> var1, String var2);

    public ContextBuilder properties(Properties var1, String var2);

    public ContextBuilder properties(InputStream var1, String var2) throws IOException;

    public ContextBuilder properties(Reader var1, String var2) throws IOException;

    public ContextBuilder properties(File var1, String var2) throws IOException;

    default public ContextBuilder properties(Properties properties) {
        return this.properties(properties, (String)null);
    }

    default public ContextBuilder properties(InputStream stream) throws IOException {
        return this.properties(stream, null);
    }

    default public ContextBuilder properties(Reader reader) throws IOException {
        return this.properties(reader, null);
    }

    default public ContextBuilder properties(File file) throws IOException {
        return this.properties(file, null);
    }

    default public ContextBuilder addProperty(String key, String value) {
        return this.property(key, value);
    }

    default public ContextBuilder addProperty(Map.Entry<String, String> ... value) {
        return this.property(value);
    }

    default public ContextBuilder addProperties(Properties properties, String prefixFilter) {
        return this.properties(properties, prefixFilter);
    }

    default public ContextBuilder addProperties(Properties properties) {
        return this.properties(properties, (String)null);
    }

    default public ContextBuilder addProperties(Map<String, String> properties) {
        return this.properties(properties, null);
    }

    default public ContextBuilder addProperties(Map<String, String> properties, String prefixFilter) {
        return this.properties(properties, prefixFilter);
    }

    default public ContextBuilder addProperties(InputStream stream) throws IOException {
        return this.properties(stream, null);
    }

    default public ContextBuilder addProperties(InputStream stream, String prefixFilter) throws IOException {
        return this.properties(stream, prefixFilter);
    }

    default public ContextBuilder addProperties(Reader reader) throws IOException {
        return this.properties(reader, null);
    }

    default public ContextBuilder addProperties(Reader reader, String prefixFilter) throws IOException {
        return this.properties(reader, prefixFilter);
    }

    default public ContextBuilder addProperties(File file) throws IOException {
        return this.properties(file, null);
    }

    default public ContextBuilder addProperties(File file, String prefixFilter) throws IOException {
        return this.properties(file, prefixFilter);
    }

    default public ContextBuilder add(Properties properties, String prefixFilter) {
        return this.properties(properties, prefixFilter);
    }

    default public ContextBuilder add(Properties properties) {
        return this.properties(properties, (String)null);
    }
}

