/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.common.impl;

import com.pi4j.common.Descriptor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class DescriptorImpl
implements Descriptor {
    private Set<Descriptor> children = Collections.synchronizedSet(new LinkedHashSet());
    private Descriptor parent = null;
    private String id;
    private String name;
    private String description;
    private String category;
    private Integer quantity;
    private Class type;
    private Object value;

    @Override
    public Descriptor id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public Descriptor name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public Descriptor description(String description) {
        this.description = description;
        return this;
    }

    @Override
    public Descriptor category(String category) {
        this.category = category;
        return this;
    }

    @Override
    public Descriptor quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Override
    public Descriptor value(Object value) {
        this.value = value;
        return this;
    }

    @Override
    public Descriptor type(Class type) {
        this.type = type;
        return this;
    }

    @Override
    public Descriptor parent(Descriptor parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public String category() {
        return this.category;
    }

    @Override
    public Integer quantity() {
        return this.quantity;
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public Class type() {
        return this.type;
    }

    @Override
    public Descriptor parent() {
        return this.parent;
    }

    @Override
    public Descriptor add(Descriptor descriptor) {
        if (descriptor != null) {
            this.children.add(descriptor.parent(this));
        }
        return this;
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    @Override
    public boolean isNotEmpty() {
        return !this.children.isEmpty();
    }

    @Override
    public void print(PrintStream stream) {
        this.print(stream, "", new ArrayList<Boolean>());
    }

    private void print(PrintStream stream, String prefix, ArrayList<Boolean> parents) {
        stream.print(prefix);
        if (this.category != null) {
            stream.print(this.category);
            stream.print(": ");
        }
        if (this.quantity != null) {
            stream.print("[");
            stream.print(this.quantity.toString());
            stream.print("] ");
        }
        if (this.name != null) {
            stream.print("\"");
            stream.print(this.name);
            stream.print("\" ");
        }
        if (this.value != null) {
            stream.print("= ");
            stream.print(this.value.toString());
            stream.print(" ");
        }
        if (this.id != null) {
            stream.print("{");
            stream.print(this.id);
            stream.print("} ");
        }
        if (this.type != null) {
            stream.print("<");
            stream.print(this.type.getName());
            stream.print("> ");
        }
        if (this.description != null) {
            stream.print("{");
            stream.print(this.description);
            stream.print("} ");
        }
        stream.println();
        Set children = this.children.stream().collect(Collectors.toSet());
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            Object p = "";
            for (Boolean parentHasNext : parents) {
                p = (String)p + (parentHasNext != false ? "\u2502 " : "  ");
            }
            p = (String)p + (iterator.hasNext() ? "\u251c\u2500" : "\u2514\u2500");
            parents.add(iterator.hasNext());
            if (descriptor instanceof Descriptor) {
                ((DescriptorImpl)descriptor).print(stream, (String)p, parents);
            }
            parents.remove(parents.size() - 1);
        }
    }
}

