/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.schema;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.schema.AllOf;
import com.alibaba.fastjson2.schema.Any;
import com.alibaba.fastjson2.schema.AnyOf;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.schema.OneOf;
import com.alibaba.fastjson2.schema.ValidateResult;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ArraySchema
extends JSONSchema {
    final Map<String, JSONSchema> definitions;
    final Map<String, JSONSchema> defs;
    final boolean typed;
    final int maxLength;
    final int minLength;
    JSONSchema itemSchema;
    final JSONSchema[] prefixItems;
    final boolean additionalItems;
    final JSONSchema additionalItem;
    final JSONSchema contains;
    final int minContains;
    final int maxContains;
    final boolean uniqueItems;
    final AllOf allOf;
    final AnyOf anyOf;
    final OneOf oneOf;

    public ArraySchema(JSONObject input, JSONSchema root) {
        super(input);
        boolean additionalItemsSupport;
        JSONObject defs;
        this.typed = "array".equals(input.get("type"));
        this.definitions = new LinkedHashMap<String, JSONSchema>();
        this.defs = new LinkedHashMap<String, JSONSchema>();
        JSONObject definitions = input.getJSONObject("definitions");
        if (definitions != null) {
            for (Map.Entry entry : definitions.entrySet()) {
                String string = (String)entry.getKey();
                JSONObject entryValue = (JSONObject)entry.getValue();
                JSONSchema schema = JSONSchema.of(entryValue, root == null ? this : root);
                this.definitions.put(string, schema);
            }
        }
        if ((defs = input.getJSONObject("$defs")) != null) {
            for (Map.Entry entry : defs.entrySet()) {
                String entryKey = (String)entry.getKey();
                JSONObject entryValue = (JSONObject)entry.getValue();
                JSONSchema schema = JSONSchema.of(entryValue, root == null ? this : root);
                this.defs.put(entryKey, schema);
            }
        }
        this.minLength = input.getIntValue("minItems", -1);
        this.maxLength = input.getIntValue("maxItems", -1);
        Object object = input.get("items");
        Object object2 = input.get("additionalItems");
        JSONArray prefixItems = input.getJSONArray("prefixItems");
        if (object == null) {
            additionalItemsSupport = true;
            this.itemSchema = null;
        } else if (object instanceof Boolean) {
            additionalItemsSupport = (Boolean)object;
            this.itemSchema = null;
        } else if (object instanceof JSONArray) {
            if (prefixItems != null) {
                throw new JSONException("schema error, items : " + object);
            }
            prefixItems = (JSONArray)object;
            this.itemSchema = null;
            additionalItemsSupport = true;
        } else {
            additionalItemsSupport = true;
            this.itemSchema = JSONSchema.of((JSONObject)object, root != null ? root : this);
        }
        if (object2 instanceof JSONObject) {
            this.additionalItem = JSONSchema.of((JSONObject)object2, root == null ? this : root);
            additionalItemsSupport = true;
        } else if (object2 instanceof Boolean) {
            additionalItemsSupport = (Boolean)object2;
            this.additionalItem = null;
        } else {
            this.additionalItem = null;
        }
        if (this.itemSchema != null && !(this.itemSchema instanceof Any)) {
            additionalItemsSupport = true;
        } else if (prefixItems == null && !(object instanceof Boolean)) {
            additionalItemsSupport = true;
        }
        this.additionalItems = additionalItemsSupport;
        if (prefixItems == null) {
            this.prefixItems = new JSONSchema[0];
        } else {
            this.prefixItems = new JSONSchema[prefixItems.size()];
            for (int i = 0; i < prefixItems.size(); ++i) {
                JSONSchema schema;
                Object prefixItem = prefixItems.get(i);
                if (prefixItem instanceof Boolean) {
                    schema = (Boolean)prefixItem != false ? Any.INSTANCE : Any.NOT_ANY;
                } else {
                    JSONObject jsonObject = (JSONObject)prefixItem;
                    schema = JSONSchema.of(jsonObject, root == null ? this : root);
                }
                this.prefixItems[i] = schema;
            }
        }
        this.contains = input.getObject("contains", JSONSchema::of);
        this.minContains = input.getIntValue("minContains", -1);
        this.maxContains = input.getIntValue("maxContains", -1);
        this.uniqueItems = input.getBooleanValue("uniqueItems");
        this.allOf = ArraySchema.allOf(input, null);
        this.anyOf = ArraySchema.anyOf(input, null);
        this.oneOf = ArraySchema.oneOf(input, null);
    }

    @Override
    public JSONSchema.Type getType() {
        return JSONSchema.Type.Array;
    }

    @Override
    public ValidateResult validate(Object value) {
        if (value == null) {
            return this.typed ? FAIL_INPUT_NULL : SUCCESS;
        }
        HashSet<Object> uniqueItemsSet = null;
        if (value instanceof Object[]) {
            ValidateResult result;
            Object[] array = (Object[])value;
            int size = array.length;
            if (this.minLength >= 0 && size < this.minLength) {
                return new ValidateResult(false, "minLength not match, expect >= %s, but %s", this.minLength, size);
            }
            if (this.maxLength >= 0 && size > this.maxLength) {
                return new ValidateResult(false, "maxLength not match, expect <= %s, but %s", this.maxLength, size);
            }
            int containsCount = 0;
            for (int index = 0; index < array.length; ++index) {
                ValidateResult result2;
                Object item = array[index];
                boolean prefixMatch = false;
                if (index < this.prefixItems.length) {
                    result2 = this.prefixItems[index].validate(item);
                    if (!result2.isSuccess()) {
                        return result2;
                    }
                    prefixMatch = true;
                }
                if (!prefixMatch && this.itemSchema != null && !(result2 = this.itemSchema.validate(item)).isSuccess()) {
                    return result2;
                }
                if (this.contains != null && (this.minContains > 0 || this.maxContains > 0 || containsCount == 0) && (result2 = this.contains.validate(item)) == SUCCESS) {
                    ++containsCount;
                }
                if (!this.uniqueItems) continue;
                if (uniqueItemsSet == null) {
                    uniqueItemsSet = new HashSet<Object>(size);
                }
                if (item instanceof BigDecimal) {
                    item = ((BigDecimal)item).stripTrailingZeros();
                }
                if (uniqueItemsSet.add(item)) continue;
                return UNIQUE_ITEMS_NOT_MATCH;
            }
            if (this.contains != null && containsCount == 0) {
                return CONTAINS_NOT_MATCH;
            }
            if (this.minContains >= 0 && containsCount < this.minContains) {
                return new ValidateResult(false, "minContains not match, expect %s, but %s", this.minContains, containsCount);
            }
            if (this.maxContains >= 0 && containsCount > this.maxContains) {
                return new ValidateResult(false, "maxContains not match, expect %s, but %s", this.maxContains, containsCount);
            }
            if (!this.additionalItems && size > this.prefixItems.length) {
                return new ValidateResult(false, "additional items not match, max size %s, but %s", this.prefixItems.length, size);
            }
            if (this.allOf != null && !(result = this.allOf.validate(value)).isSuccess()) {
                return result;
            }
            if (this.anyOf != null && !(result = this.anyOf.validate(value)).isSuccess()) {
                return result;
            }
            if (this.oneOf != null && !(result = this.oneOf.validate(value)).isSuccess()) {
                return result;
            }
            return SUCCESS;
        }
        if (value.getClass().isArray()) {
            ValidateResult result;
            int size = Array.getLength(value);
            if (this.minLength >= 0 && size < this.minLength) {
                return new ValidateResult(false, "minLength not match, expect >= %s, but %s", this.minLength, size);
            }
            if (this.maxLength >= 0 && size > this.maxLength) {
                return new ValidateResult(false, "maxLength not match, expect <= %s, but %s", this.maxLength, size);
            }
            int containsCount = 0;
            for (int index = 0; index < size; ++index) {
                ValidateResult result3;
                Object item = Array.get(value, index);
                boolean prefixMatch = false;
                if (index < this.prefixItems.length) {
                    result3 = this.prefixItems[index].validate(item);
                    if (!result3.isSuccess()) {
                        return result3;
                    }
                    prefixMatch = true;
                }
                if (!prefixMatch && this.itemSchema != null && !(result3 = this.itemSchema.validate(item)).isSuccess()) {
                    return result3;
                }
                if (this.contains != null && (this.minContains > 0 || this.maxContains > 0 || containsCount == 0) && (result3 = this.contains.validate(item)) == SUCCESS) {
                    ++containsCount;
                }
                if (!this.uniqueItems) continue;
                if (uniqueItemsSet == null) {
                    uniqueItemsSet = new HashSet(size);
                }
                if (item instanceof BigDecimal) {
                    item = ((BigDecimal)item).stripTrailingZeros();
                }
                if (uniqueItemsSet.add(item)) continue;
                return UNIQUE_ITEMS_NOT_MATCH;
            }
            if (this.contains != null && containsCount == 0) {
                return CONTAINS_NOT_MATCH;
            }
            if (this.minContains >= 0 && containsCount < this.minContains) {
                return new ValidateResult(false, "minContains not match, expect %s, but %s", this.minContains, containsCount);
            }
            if (this.maxContains >= 0 && containsCount > this.maxContains) {
                return new ValidateResult(false, "maxContains not match, expect %s, but %s", this.maxContains, containsCount);
            }
            if (!this.additionalItems && size > this.prefixItems.length) {
                return new ValidateResult(false, "additional items not match, max size %s, but %s", this.prefixItems.length, size);
            }
            if (this.allOf != null && !(result = this.allOf.validate(value)).isSuccess()) {
                return result;
            }
            if (this.anyOf != null && !(result = this.anyOf.validate(value)).isSuccess()) {
                return result;
            }
            if (this.oneOf != null && !(result = this.oneOf.validate(value)).isSuccess()) {
                return result;
            }
            return SUCCESS;
        }
        if (value instanceof Collection) {
            ValidateResult result;
            int size = ((Collection)value).size();
            if (this.minLength >= 0 && size < this.minLength) {
                return new ValidateResult(false, "minLength not match, expect >= %s, but %s", this.minLength, size);
            }
            if (this.maxLength >= 0 && size > this.maxLength) {
                return new ValidateResult(false, "maxLength not match, expect <= %s, but %s", this.maxLength, size);
            }
            if (!this.additionalItems && size > this.prefixItems.length) {
                return new ValidateResult(false, "additional items not match, max size %s, but %s", this.prefixItems.length, size);
            }
            int index = 0;
            int containsCount = 0;
            for (Object item : (Iterable)value) {
                ValidateResult result4;
                boolean prefixMatch = false;
                if (index < this.prefixItems.length) {
                    result4 = this.prefixItems[index].validate(item);
                    if (!result4.isSuccess()) {
                        return result4;
                    }
                    prefixMatch = true;
                } else if (this.itemSchema == null && this.additionalItem != null && !(result4 = this.additionalItem.validate(item)).isSuccess()) {
                    return result4;
                }
                if (!prefixMatch && this.itemSchema != null && !(result4 = this.itemSchema.validate(item)).isSuccess()) {
                    return result4;
                }
                if (this.contains != null && (this.minContains > 0 || this.maxContains > 0 || containsCount == 0) && (result4 = this.contains.validate(item)) == SUCCESS) {
                    ++containsCount;
                }
                if (this.uniqueItems) {
                    if (uniqueItemsSet == null) {
                        uniqueItemsSet = new HashSet();
                    }
                    if (item instanceof BigDecimal) {
                        item = ((BigDecimal)item).stripTrailingZeros();
                    }
                    if (!uniqueItemsSet.add(item)) {
                        return UNIQUE_ITEMS_NOT_MATCH;
                    }
                }
                ++index;
            }
            if (this.contains != null) {
                if (this.minContains >= 0 && containsCount < this.minContains) {
                    return new ValidateResult(false, "minContains not match, expect %s, but %s", this.minContains, containsCount);
                }
                if (containsCount == 0 && this.minContains != 0) {
                    return CONTAINS_NOT_MATCH;
                }
                if (this.maxContains >= 0 && containsCount > this.maxContains) {
                    return new ValidateResult(false, "maxContains not match, expect %s, but %s", this.maxContains, containsCount);
                }
            }
            if (this.allOf != null && !(result = this.allOf.validate(value)).isSuccess()) {
                return result;
            }
            if (this.anyOf != null && !(result = this.anyOf.validate(value)).isSuccess()) {
                return result;
            }
            if (this.oneOf != null && !(result = this.oneOf.validate(value)).isSuccess()) {
                return result;
            }
            return SUCCESS;
        }
        return this.typed ? FAIL_TYPE_NOT_MATCH : SUCCESS;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject object = new JSONObject();
        object.put("type", "array");
        if (this.maxLength != -1) {
            object.put("maxLength", this.maxLength);
        }
        if (this.minLength != -1) {
            object.put("minLength", this.minLength);
        }
        if (this.itemSchema != null) {
            object.put("items", this.itemSchema);
        }
        if (this.prefixItems != null && this.prefixItems.length != 0) {
            object.put("prefixItems", this.prefixItems);
        }
        if (!this.additionalItems) {
            object.put("additionalItems", this.additionalItems);
        }
        if (this.additionalItem != null) {
            object.put("additionalItem", this.additionalItem);
        }
        if (this.contains != null) {
            object.put("contains", this.contains);
        }
        if (this.minContains != -1) {
            object.put("minContains", this.minContains);
        }
        if (this.maxContains != -1) {
            object.put("maxContains", this.maxContains);
        }
        if (this.uniqueItems) {
            object.put("uniqueItems", this.uniqueItems);
        }
        if (this.allOf != null) {
            object.put("allOf", this.allOf);
        }
        if (this.anyOf != null) {
            object.put("anyOf", this.anyOf);
        }
        if (this.oneOf != null) {
            object.put("oneOf", this.oneOf);
        }
        return object;
    }
}

