/*
 * Decompiled with CFR 0.152.
 */
package cn.tpkf.rpi.utils;

import cn.tpkf.rpi.pojo.PlatformInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;

public class SystemInfoUtils {
    private static final Logger log = LoggerFactory.getLogger(SystemInfoUtils.class);
    private static final SystemInfo SYSTEM_INFO = new SystemInfo();
    private static CpuTicksInfo cpuTicks;
    private static final ReentrantLock LOCK;
    private static final PlatformInfo.CupInfo CPU_INFO;
    private static final PlatformInfo.MemoryInfo MEMORY_INFO;
    private static final long TIME_OUT = 2500L;
    private static final long UPDATE_SEC = 3L;

    private SystemInfoUtils() {
    }

    private static void updateCpuTicks() {
        long[] oldTicks = SystemInfoUtils.getSystemCpuLoadTicks();
        try {
            TimeUnit.SECONDS.sleep(3L);
        }
        catch (InterruptedException e) {
            log.error("init calculate system info error: {}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
        long[] newTicks = SystemInfoUtils.getSystemCpuLoadTicks();
        SystemInfoUtils.setCpuTicks(oldTicks, newTicks);
    }

    private static void setCpuTicks(long[] oldTicks, long[] newTicks) {
        try {
            if (LOCK.tryLock(2500L, TimeUnit.MICROSECONDS)) {
                cpuTicks = new CpuTicksInfo(oldTicks, newTicks);
            }
        }
        catch (InterruptedException e) {
            log.error("set cpu ticks info error: {}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
        finally {
            LOCK.unlock();
        }
    }

    private static CpuTicksInfo getCpuTicks() {
        try {
            if (LOCK.tryLock(2500L, TimeUnit.MICROSECONDS)) {
                CpuTicksInfo cpuTicksInfo = cpuTicks;
                return cpuTicksInfo;
            }
        }
        catch (InterruptedException e) {
            log.error("get cpu ticks info error: {}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
        finally {
            LOCK.unlock();
        }
        return null;
    }

    public static CentralProcessor getCentralProcess() {
        return SYSTEM_INFO.getHardware().getProcessor();
    }

    public static HardwareAbstractionLayer getHardware() {
        return SYSTEM_INFO.getHardware();
    }

    public static long getTotalMemory() {
        GlobalMemory globalMemory = SystemInfoUtils.getHardware().getMemory();
        return globalMemory.getTotal();
    }

    public static long getUsedMemory() {
        return SystemInfoUtils.getTotalMemory() - SystemInfoUtils.getFreeMemory();
    }

    public static long getFreeMemory() {
        return SystemInfoUtils.getHardware().getMemory().getAvailable();
    }

    public static long[] getSystemCpuLoadTicks() {
        return SystemInfoUtils.getCentralProcess().getSystemCpuLoadTicks();
    }

    public static double getCpuUsageRate() {
        CpuTicksInfo cpuInfo = SystemInfoUtils.getCpuTicks();
        if (Objects.isNull(cpuInfo)) {
            return 0.0;
        }
        return cpuInfo.getUsageRate();
    }

    public static double getCpuTemperature() {
        return SystemInfoUtils.getHardware().getSensors().getCpuTemperature();
    }

    public static PlatformInfo getPlatformInfo() {
        CPU_INFO.setUsageRate(SystemInfoUtils.getCpuUsageRate());
        CPU_INFO.setTemperature(SystemInfoUtils.getCpuTemperature());
        MEMORY_INFO.setUsedMemory(SystemInfoUtils.getUsedMemory());
        MEMORY_INFO.setFreeMemory(SystemInfoUtils.getFreeMemory());
        PlatformInfo platformInfo = new PlatformInfo();
        platformInfo.setCupInfo(CPU_INFO);
        platformInfo.setMemoryInfo(MEMORY_INFO);
        platformInfo.setCurrentTime(LocalDateTime.now());
        return platformInfo;
    }

    static {
        LOCK = new ReentrantLock(true);
        CPU_INFO = new PlatformInfo.CupInfo();
        MEMORY_INFO = new PlatformInfo.MemoryInfo();
        CentralProcessor processor = SystemInfoUtils.getHardware().getProcessor();
        CentralProcessor.ProcessorIdentifier processorIdentifier = SystemInfoUtils.getHardware().getProcessor().getProcessorIdentifier();
        CPU_INFO.setName(processorIdentifier.getName()).setProcessorId(processorIdentifier.getProcessorID()).setFamily(processorIdentifier.getFamily()).setIs64Bit(processorIdentifier.isCpu64bit()).setVendor(processorIdentifier.getVendor()).setStepping(processorIdentifier.getStepping()).setMicroArchitecture(processorIdentifier.getMicroarchitecture()).setIdentifier(processorIdentifier.getIdentifier()).setModel(processorIdentifier.getModel()).setProcessorCount(processor.getLogicalProcessorCount()).setMaxFreq(processor.getMaxFreq());
        MEMORY_INFO.setTotalMemory(SystemInfoUtils.getTotalMemory());
        long[] oldTicks = SystemInfoUtils.getSystemCpuLoadTicks();
        long[] newTicks = SystemInfoUtils.getSystemCpuLoadTicks();
        SystemInfoUtils.setCpuTicks(oldTicks, newTicks);
        Thread cpuTicksUpdater = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        SystemInfoUtils.updateCpuTicks();
                    }
                }
                catch (Exception e) {
                    log.warn("update cpu ticks error: {}", (Object)e.getMessage());
                    continue;
                }
                break;
            }
        });
        cpuTicksUpdater.setDaemon(true);
        cpuTicksUpdater.start();
    }

    private static class CpuTicksInfo
    implements Serializable {
        private long nice;
        private long irq;
        private long softIrq;
        private long steal;
        private long system;
        private long user;
        private long ioWait;
        private long idle;
        private long total;
        private double sysUsageRate;
        private double userUsageRate;
        private double waitUsageRate;
        private double usageRate;

        public CpuTicksInfo(long[] oldTicks, long[] newTicks) {
            this.nice = newTicks[CentralProcessor.TickType.NICE.getIndex()] - oldTicks[CentralProcessor.TickType.NICE.getIndex()];
            this.irq = newTicks[CentralProcessor.TickType.IRQ.getIndex()] - oldTicks[CentralProcessor.TickType.IRQ.getIndex()];
            this.softIrq = newTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()] - oldTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
            this.steal = newTicks[CentralProcessor.TickType.STEAL.getIndex()] - oldTicks[CentralProcessor.TickType.STEAL.getIndex()];
            this.system = newTicks[CentralProcessor.TickType.SYSTEM.getIndex()] - oldTicks[CentralProcessor.TickType.SYSTEM.getIndex()];
            this.user = newTicks[CentralProcessor.TickType.USER.getIndex()] - oldTicks[CentralProcessor.TickType.USER.getIndex()];
            this.ioWait = newTicks[CentralProcessor.TickType.IOWAIT.getIndex()] - oldTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
            this.idle = newTicks[CentralProcessor.TickType.IDLE.getIndex()] - oldTicks[CentralProcessor.TickType.IDLE.getIndex()];
            this.total = this.user + this.nice + this.system + this.idle + this.ioWait + this.irq + this.softIrq + this.steal;
            this.sysUsageRate = this.divide(this.system, this.total);
            this.userUsageRate = this.divide(this.user, this.total);
            this.waitUsageRate = this.divide(this.ioWait, this.total);
            this.usageRate = this.divide(this.idle, this.total);
        }

        private double divide(long num, long divide) {
            BigDecimal result = new BigDecimal(num).divide(new BigDecimal(divide), 4, RoundingMode.HALF_UP);
            return new BigDecimal(1).subtract(result, new MathContext(4)).doubleValue();
        }

        public long getNice() {
            return this.nice;
        }

        public long getIrq() {
            return this.irq;
        }

        public long getSoftIrq() {
            return this.softIrq;
        }

        public long getSteal() {
            return this.steal;
        }

        public long getSystem() {
            return this.system;
        }

        public long getUser() {
            return this.user;
        }

        public long getIoWait() {
            return this.ioWait;
        }

        public long getIdle() {
            return this.idle;
        }

        public long getTotal() {
            return this.total;
        }

        public double getSysUsageRate() {
            return this.sysUsageRate;
        }

        public double getUserUsageRate() {
            return this.userUsageRate;
        }

        public double getWaitUsageRate() {
            return this.waitUsageRate;
        }

        public double getUsageRate() {
            return this.usageRate;
        }

        public void setNice(long nice) {
            this.nice = nice;
        }

        public void setIrq(long irq) {
            this.irq = irq;
        }

        public void setSoftIrq(long softIrq) {
            this.softIrq = softIrq;
        }

        public void setSteal(long steal) {
            this.steal = steal;
        }

        public void setSystem(long system) {
            this.system = system;
        }

        public void setUser(long user) {
            this.user = user;
        }

        public void setIoWait(long ioWait) {
            this.ioWait = ioWait;
        }

        public void setIdle(long idle) {
            this.idle = idle;
        }

        public void setTotal(long total) {
            this.total = total;
        }

        public void setSysUsageRate(double sysUsageRate) {
            this.sysUsageRate = sysUsageRate;
        }

        public void setUserUsageRate(double userUsageRate) {
            this.userUsageRate = userUsageRate;
        }

        public void setWaitUsageRate(double waitUsageRate) {
            this.waitUsageRate = waitUsageRate;
        }

        public void setUsageRate(double usageRate) {
            this.usageRate = usageRate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CpuTicksInfo)) {
                return false;
            }
            CpuTicksInfo other = (CpuTicksInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getNice() != other.getNice()) {
                return false;
            }
            if (this.getIrq() != other.getIrq()) {
                return false;
            }
            if (this.getSoftIrq() != other.getSoftIrq()) {
                return false;
            }
            if (this.getSteal() != other.getSteal()) {
                return false;
            }
            if (this.getSystem() != other.getSystem()) {
                return false;
            }
            if (this.getUser() != other.getUser()) {
                return false;
            }
            if (this.getIoWait() != other.getIoWait()) {
                return false;
            }
            if (this.getIdle() != other.getIdle()) {
                return false;
            }
            if (this.getTotal() != other.getTotal()) {
                return false;
            }
            if (Double.compare(this.getSysUsageRate(), other.getSysUsageRate()) != 0) {
                return false;
            }
            if (Double.compare(this.getUserUsageRate(), other.getUserUsageRate()) != 0) {
                return false;
            }
            if (Double.compare(this.getWaitUsageRate(), other.getWaitUsageRate()) != 0) {
                return false;
            }
            return Double.compare(this.getUsageRate(), other.getUsageRate()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof CpuTicksInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $nice = this.getNice();
            result = result * 59 + (int)($nice >>> 32 ^ $nice);
            long $irq = this.getIrq();
            result = result * 59 + (int)($irq >>> 32 ^ $irq);
            long $softIrq = this.getSoftIrq();
            result = result * 59 + (int)($softIrq >>> 32 ^ $softIrq);
            long $steal = this.getSteal();
            result = result * 59 + (int)($steal >>> 32 ^ $steal);
            long $system = this.getSystem();
            result = result * 59 + (int)($system >>> 32 ^ $system);
            long $user = this.getUser();
            result = result * 59 + (int)($user >>> 32 ^ $user);
            long $ioWait = this.getIoWait();
            result = result * 59 + (int)($ioWait >>> 32 ^ $ioWait);
            long $idle = this.getIdle();
            result = result * 59 + (int)($idle >>> 32 ^ $idle);
            long $total = this.getTotal();
            result = result * 59 + (int)($total >>> 32 ^ $total);
            long $sysUsageRate = Double.doubleToLongBits(this.getSysUsageRate());
            result = result * 59 + (int)($sysUsageRate >>> 32 ^ $sysUsageRate);
            long $userUsageRate = Double.doubleToLongBits(this.getUserUsageRate());
            result = result * 59 + (int)($userUsageRate >>> 32 ^ $userUsageRate);
            long $waitUsageRate = Double.doubleToLongBits(this.getWaitUsageRate());
            result = result * 59 + (int)($waitUsageRate >>> 32 ^ $waitUsageRate);
            long $usageRate = Double.doubleToLongBits(this.getUsageRate());
            result = result * 59 + (int)($usageRate >>> 32 ^ $usageRate);
            return result;
        }

        public String toString() {
            return "SystemInfoUtils.CpuTicksInfo(nice=" + this.getNice() + ", irq=" + this.getIrq() + ", softIrq=" + this.getSoftIrq() + ", steal=" + this.getSteal() + ", system=" + this.getSystem() + ", user=" + this.getUser() + ", ioWait=" + this.getIoWait() + ", idle=" + this.getIdle() + ", total=" + this.getTotal() + ", sysUsageRate=" + this.getSysUsageRate() + ", userUsageRate=" + this.getUserUsageRate() + ", waitUsageRate=" + this.getWaitUsageRate() + ", usageRate=" + this.getUsageRate() + ")";
        }

        public CpuTicksInfo() {
        }
    }
}

