/*
 * Decompiled with CFR 0.152.
 */
package cn.tpkf.rpi.manager;

import cn.hutool.core.io.resource.ResourceUtil;
import cn.tpkf.rpi.devices.Device;
import cn.tpkf.rpi.exception.DeviceManagerException;
import cn.tpkf.rpi.manager.ContextCommand;
import cn.tpkf.rpi.pojo.PlatformInfo;
import cn.tpkf.rpi.utils.SystemInfoUtils;
import com.pi4j.Pi4J;
import com.pi4j.common.Descriptor;
import com.pi4j.context.Context;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceManager {
    private static final Logger log = LoggerFactory.getLogger(DeviceManager.class);
    private final Context context;
    private final Long timeOutMillis;
    private final ReentrantLock lock;
    private final Map<String, Device> devices = new ConcurrentHashMap<String, Device>();

    public DeviceManager() {
        this.context = Pi4J.newAutoContext();
        this.timeOutMillis = 2000L;
        this.lock = new ReentrantLock();
    }

    public DeviceManager(Context context) {
        this(context, 2000L);
    }

    public DeviceManager(Context context, Long timeOutMillis) {
        this.context = context;
        this.timeOutMillis = timeOutMillis;
        this.lock = new ReentrantLock();
    }

    public String printBanner() {
        String banner = ResourceUtil.readUtf8Str("static/banner.txt");
        Descriptor describe = this.context.platform().describe();
        String describeInfo = String.format("%s%nId: %s%nName: %s%nCategory: %s%nQuantity: %s%nParent: %s%nValue: %s%n", banner, describe.id(), describe.name(), describe.category(), describe.quantity(), describe.parent(), describe.value());
        log.info(describeInfo);
        return describeInfo;
    }

    public <T> T execute(ContextCommand<T> command) {
        if (!this.isRunning()) {
            throw new DeviceManagerException("Context is not running");
        }
        try {
            boolean isLocked = this.lock.tryLock(this.timeOutMillis, TimeUnit.MILLISECONDS);
            if (isLocked) {
                T t = command.execute(this.context);
                return t;
            }
            try {
                throw new DeviceManagerException("Acquire lock timeout");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DeviceManagerException("Fail to acquire lock", e);
            }
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    public void addDevice(Device device) {
        if (StringUtils.isBlank(device.getId())) {
            throw new DeviceManagerException("Device id or name is blank");
        }
        this.devices.put(device.getId(), device);
    }

    public void removeDevice(String id) {
        this.devices.remove(id);
    }

    public Device getDevice(String id) {
        return this.devices.get(id);
    }

    public boolean isRunning() {
        return Objects.nonNull(this.context) && !this.context.isShutdown();
    }

    public boolean shutdown() {
        if (this.isRunning()) {
            this.context.shutdown();
        }
        return true;
    }

    public PlatformInfo getPlatformInfo() {
        return SystemInfoUtils.getPlatformInfo();
    }

    public DeviceManager(Context context, Long timeOutMillis, ReentrantLock lock) {
        this.context = context;
        this.timeOutMillis = timeOutMillis;
        this.lock = lock;
    }
}

