/*
 * Decompiled with CFR 0.152.
 */
package cn.tpkf.rpi.devices.i2c;

import cn.tpkf.rpi.devices.i2c.AbstractI2cDevice;
import cn.tpkf.rpi.manager.DeviceManager;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class Pcf8591
extends AbstractI2cDevice {
    public static final Integer DEFAULT_ADDRESS = 72;
    public static final Byte AIN_0 = 69;
    private static final Byte AIN_1 = 70;
    private static final Byte AIN_2 = 71;
    private static final Byte AIN_3 = 68;
    private final BigDecimal constantNum;
    private final Integer maxVoltage;

    public Pcf8591(DeviceManager deviceManager, String id, String name, Integer bus, Integer device, Integer maxVoltage) {
        super(deviceManager, id, name, bus, device);
        this.maxVoltage = maxVoltage;
        BigDecimal maxVoltageDecimal = new BigDecimal(maxVoltage);
        this.constantNum = maxVoltageDecimal.divide(new BigDecimal(255), 4, RoundingMode.HALF_UP);
    }

    public Pcf8591(DeviceManager deviceManager, String id, String name, Integer bus) {
        this(deviceManager, id, name, bus, DEFAULT_ADDRESS, 5);
    }

    public double readAin0() {
        return this.read(AIN_0);
    }

    public double readAin1() {
        return this.read(AIN_1);
    }

    public double readAin2() {
        return this.read(AIN_2);
    }

    public double readAin3() {
        return this.read(AIN_3);
    }

    public double read(Byte aIn) {
        int value = this.i2C.readRegister(aIn.byteValue());
        return this.constantNum.multiply(new BigDecimal(value)).doubleValue();
    }

    public Integer getMaxVoltage() {
        return this.maxVoltage;
    }
}

