/*
 * Decompiled with CFR 0.152.
 */
package cn.tpkf.rpi.devices.i2c;

import cn.tpkf.rpi.devices.AbstractDevice;
import cn.tpkf.rpi.manager.DeviceManager;
import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CConfigBuilder;
import com.pi4j.plugin.pigpio.provider.i2c.PiGpioI2CProvider;

public abstract class AbstractI2cDevice
extends AbstractDevice {
    protected final I2C i2C;
    protected final Integer bus;
    protected final Integer device;

    protected AbstractI2cDevice(DeviceManager deviceManager, String id, String name, Integer bus, Integer device) {
        super(deviceManager, id, name);
        this.bus = bus;
        this.device = device;
        this.i2C = deviceManager.execute(c -> {
            I2CConfig config = (I2CConfig)((I2CConfigBuilder)((I2CConfigBuilder)((I2CConfigBuilder)((I2CConfigBuilder)I2CConfigBuilder.newInstance(c).id(id)).name(name)).bus(bus).device(device).description(this.getDescription())).provider(PiGpioI2CProvider.class)).build();
            return c.create(config);
        });
        deviceManager.addDevice(this);
    }

    @Override
    public String getDescription() {
        return this.id + "-I2C-BUS " + this.bus + " DEVICE " + this.device + "-" + this.name;
    }

    public Integer getBus() {
        return this.bus;
    }

    public Integer getDevice() {
        return this.device;
    }
}

