/*
 * Decompiled with CFR 0.152.
 */
package cn.tpkf.rpi.devices.gpio.w1.dht;

import cn.tpkf.rpi.devices.gpio.w1.dht.AbstractDhtDevice;
import cn.tpkf.rpi.enums.IBCMEnums;
import cn.tpkf.rpi.exception.DeviceException;
import cn.tpkf.rpi.manager.DeviceManager;
import java.util.Arrays;

public class Dht22
extends AbstractDhtDevice {
    protected Dht22(DeviceManager deviceManager, String id, String name, IBCMEnums address) {
        super(deviceManager, id, name, address, 1, 80L, 130L);
    }

    @Override
    protected AbstractDhtDevice.HumitureInfo processData(long[] data) {
        for (int i = 0; i < data.length; ++i) {
            data[i] = data[i] > 28000L ? 1L : 0L;
        }
        long[] humidityIntegerBits = Arrays.copyOfRange(data, 0, 8);
        long[] humidityDecimalBits = Arrays.copyOfRange(data, 8, 16);
        long[] temperatureIntegerBits = Arrays.copyOfRange(data, 16, 24);
        long[] temperatureDecimalBits = Arrays.copyOfRange(data, 24, 32);
        long[] verifyBits = Arrays.copyOfRange(data, 32, 40);
        int humidityInteger = 0;
        int humidityDecimal = 0;
        int temperatureInteger = 0;
        int temperatureDecimal = 0;
        int verifyNum = 0;
        for (int i = 0; i < 8; ++i) {
            humidityInteger += this.sysConvert(humidityIntegerBits[i], i);
            humidityDecimal += this.sysConvert(humidityDecimalBits[i], i);
            temperatureInteger += this.sysConvert(temperatureIntegerBits[i], i);
            temperatureDecimal += this.sysConvert(temperatureDecimalBits[i], i);
            verifyNum += this.sysConvert(verifyBits[i], i);
        }
        int sum = humidityInteger + humidityDecimal + temperatureInteger + temperatureDecimal;
        if (sum != verifyNum) {
            throw new DeviceException("Dht22 data verify error");
        }
        if (temperatureDecimalBits[0] == 1L) {
            temperatureInteger = -temperatureInteger;
        }
        return new AbstractDhtDevice.HumitureInfo(Double.valueOf(temperatureInteger + "." + temperatureDecimal), Double.valueOf(humidityInteger + "." + humidityDecimal));
    }
}

