/*
 * Decompiled with CFR 0.152.
 */
package cn.tpkf.rpi.devices.gpio.w1.dht;

import cn.tpkf.rpi.devices.gpio.w1.AbstractOneWireDevice;
import cn.tpkf.rpi.enums.IBCMEnums;
import cn.tpkf.rpi.exception.DeviceException;
import cn.tpkf.rpi.manager.DeviceManager;
import com.pi4j.io.gpio.digital.DigitalState;
import com.pi4j.io.gpio.digital.PullResistance;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDhtDevice
extends AbstractOneWireDevice {
    private static final Logger log = LoggerFactory.getLogger(AbstractDhtDevice.class);
    private static final Integer DATA_LENGTH = 40;
    private final Long waitSignalTimeOutNanos;
    private final Long readDataTimeOutNanos;
    private static final Long SEND_DATA_TIME_MILLIS = 20L;
    private Double temperature;
    private Double humidity;
    FutureTask<long[]> readDataTask = new FutureTask<long[]>(this::readData);
    private final Integer detectionInterval;
    private LocalDateTime lastDetectionTime;
    private volatile boolean keepHighSignal = true;

    protected AbstractDhtDevice(DeviceManager deviceManager, String id, String name, IBCMEnums address, Integer detectionInterval, Long waitSignalTimeOutMicros, Long readDataTimeOutMicros) {
        super(deviceManager, id, name, address, DigitalState.HIGH, DigitalState.HIGH, PullResistance.OFF);
        this.waitSignalTimeOutNanos = waitSignalTimeOutMicros * 1000L;
        this.readDataTimeOutNanos = readDataTimeOutMicros * 1000L;
        this.detectionInterval = detectionInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HumitureInfo detection() {
        try {
            this.lock.lock();
            if (Objects.nonNull(this.lastDetectionTime) && this.lastDetectionTime.plusSeconds(this.detectionInterval.intValue()).isAfter(LocalDateTime.now())) {
                HumitureInfo humitureInfo = new HumitureInfo(this.temperature, this.humidity);
                return humitureInfo;
            }
            if (Objects.isNull(this.lastDetectionTime)) {
                TimeUnit.SECONDS.sleep(2L);
            }
            this.digitalOutput.on();
            new Thread(this.readDataTask).start();
            TimeUnit.MILLISECONDS.sleep(SEND_DATA_TIME_MILLIS);
            while (this.keepHighSignal) {
                Thread.onSpinWait();
            }
            this.digitalOutput.off();
            long[] data = this.readDataTask.get();
            HumitureInfo humitureInfo = this.processData(data);
            this.temperature = humitureInfo.getTemperature();
            this.humidity = humitureInfo.getHumidity();
            this.lastDetectionTime = LocalDateTime.now();
            HumitureInfo humitureInfo2 = humitureInfo;
            return humitureInfo2;
        }
        finally {
            this.lock.unlock();
            this.digitalOutput.off();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] readData() {
        try {
            long[] data = new long[40];
            long eachReadEndTime = 0L;
            this.keepHighSignal = false;
            this.awaitSignalOff(SEND_DATA_TIME_MILLIS * 2000000L, DigitalState.LOW);
            this.awaitSignalOff(this.waitSignalTimeOutNanos, DigitalState.HIGH);
            this.awaitSignalOff(this.waitSignalTimeOutNanos, DigitalState.LOW);
            this.awaitSignalOff(this.waitSignalTimeOutNanos, DigitalState.HIGH);
            for (int dataIndex = 0; dataIndex < DATA_LENGTH; ++dataIndex) {
                this.awaitSignalOff(this.waitSignalTimeOutNanos, DigitalState.LOW);
                long nanoTimer = System.nanoTime();
                long validTime = this.readDataTimeOutNanos + nanoTimer;
                while (this.digitalInput.state() == DigitalState.HIGH) {
                    eachReadEndTime = System.nanoTime();
                    if (eachReadEndTime <= validTime) continue;
                    throw new DeviceException("Read data time out: " + (eachReadEndTime - nanoTimer) + " ns, data size: " + dataIndex);
                }
                data[dataIndex] = eachReadEndTime - nanoTimer;
            }
            long[] lArray = data;
            return lArray;
        }
        finally {
            this.keepHighSignal = true;
        }
    }

    protected abstract HumitureInfo processData(long[] var1);

    private void awaitSignalOff(long timeOutNanos, DigitalState digitalState) {
        long endTime = System.nanoTime() + timeOutNanos;
        while (this.digitalInput.state() == digitalState) {
            if (System.nanoTime() <= endTime) continue;
            throw new DeviceException("Keep " + digitalState.name() + " signal time out: " + (System.nanoTime() - endTime));
        }
    }

    protected int sysConvert(long num, int index) {
        return (int)((double)num * Math.pow(2.0, 7.0 - (double)index));
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getHumidity() {
        return this.humidity;
    }

    public static class HumitureInfo
    implements Serializable {
        private Double temperature;
        private Double humidity;

        public Double getTemperature() {
            return this.temperature;
        }

        public Double getHumidity() {
            return this.humidity;
        }

        public void setTemperature(Double temperature) {
            this.temperature = temperature;
        }

        public void setHumidity(Double humidity) {
            this.humidity = humidity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HumitureInfo)) {
                return false;
            }
            HumitureInfo other = (HumitureInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$temperature = this.getTemperature();
            Double other$temperature = other.getTemperature();
            if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
                return false;
            }
            Double this$humidity = this.getHumidity();
            Double other$humidity = other.getHumidity();
            return !(this$humidity == null ? other$humidity != null : !((Object)this$humidity).equals(other$humidity));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HumitureInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $temperature = this.getTemperature();
            result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
            Double $humidity = this.getHumidity();
            result = result * 59 + ($humidity == null ? 43 : ((Object)$humidity).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractDhtDevice.HumitureInfo(temperature=" + this.getTemperature() + ", humidity=" + this.getHumidity() + ")";
        }

        public HumitureInfo(Double temperature, Double humidity) {
            this.temperature = temperature;
            this.humidity = humidity;
        }
    }
}

