/*
 * Decompiled with CFR 0.152.
 */
package cn.tpkf.rpi.devices.gpio.w1;

import cn.tpkf.rpi.devices.gpio.AbstractGpioDevice;
import cn.tpkf.rpi.enums.IBCMEnums;
import cn.tpkf.rpi.manager.DeviceManager;
import com.pi4j.io.gpio.digital.DigitalInput;
import com.pi4j.io.gpio.digital.DigitalInputConfig;
import com.pi4j.io.gpio.digital.DigitalInputConfigBuilder;
import com.pi4j.io.gpio.digital.DigitalOutput;
import com.pi4j.io.gpio.digital.DigitalOutputConfig;
import com.pi4j.io.gpio.digital.DigitalOutputConfigBuilder;
import com.pi4j.io.gpio.digital.DigitalState;
import com.pi4j.io.gpio.digital.PullResistance;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalInputProvider;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalOutputProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOneWireDevice
extends AbstractGpioDevice {
    private static final Logger log = LoggerFactory.getLogger(AbstractOneWireDevice.class);
    private final DigitalState onState;
    private final DigitalState offState;
    protected DigitalOutput digitalOutput;
    protected DigitalInput digitalInput;

    protected AbstractOneWireDevice(DeviceManager deviceManager, String id, String name, IBCMEnums address, DigitalState initial, DigitalState shutdown, PullResistance pull) {
        super(deviceManager, id, name, address);
        if (DigitalState.LOW.equals(shutdown)) {
            this.onState = DigitalState.HIGH;
            this.offState = DigitalState.LOW;
        } else {
            this.onState = DigitalState.LOW;
            this.offState = DigitalState.HIGH;
        }
        this.digitalOutput = deviceManager.execute(c -> {
            DigitalOutputConfig config = (DigitalOutputConfig)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)DigitalOutputConfigBuilder.newInstance(c).id(id + "-OUT")).name(name)).address(address.getValue())).initial(initial).onState(this.onState)).shutdown(shutdown).provider(PiGpioDigitalOutputProvider.class)).build();
            return c.create(config);
        });
        this.digitalInput = deviceManager.execute(c -> {
            DigitalInputConfig config = (DigitalInputConfig)((DigitalInputConfigBuilder)((DigitalInputConfigBuilder)((DigitalInputConfigBuilder)((DigitalInputConfigBuilder)DigitalInputConfigBuilder.newInstance(c).id(id + "-IN")).name(name)).address(address.getValue())).pull(pull).provider(PiGpioDigitalInputProvider.class)).build();
            return c.create(config);
        });
        this.digitalOutput.off();
        deviceManager.addDevice(this);
    }

    protected boolean isHigh() {
        return this.digitalInput.isHigh();
    }

    protected boolean isLow() {
        return this.digitalInput.isLow();
    }

    @Override
    public void shutdown() {
        this.deviceManager.execute(context -> {
            this.digitalOutput.shutdown(context);
            this.digitalInput.shutdown(context);
            return null;
        });
        this.deviceManager.removeDevice(this.id);
    }

    public DigitalState getOnState() {
        return this.onState;
    }

    public DigitalState getOffState() {
        return this.offState;
    }
}

