/*
 * Decompiled with CFR 0.152.
 */
package cn.tpkf.rpi.devices.gpio.pwm;

import cn.tpkf.rpi.devices.gpio.AbstractGpioDevice;
import cn.tpkf.rpi.enums.IBCMEnums;
import cn.tpkf.rpi.manager.DeviceManager;
import com.pi4j.io.pwm.Pwm;
import com.pi4j.io.pwm.PwmConfig;
import com.pi4j.io.pwm.PwmConfigBuilder;
import com.pi4j.io.pwm.PwmPolarity;
import com.pi4j.io.pwm.PwmType;
import com.pi4j.plugin.pigpio.provider.pwm.PiGpioPwmProvider;

public abstract class AbstractPwmDevice
extends AbstractGpioDevice {
    protected final Pwm pwm;
    protected final Number initial;
    protected final Number shutdown;
    protected final Number dutyCycle;
    protected final Integer frequency;
    protected final PwmPolarity polarity;
    protected final PwmType pwmType;

    protected AbstractPwmDevice(DeviceManager deviceManager, String id, String name, IBCMEnums address, PwmType pwmType, Number initial, Number shutdown, Number dutyCycle, Integer frequency, PwmPolarity polarity) {
        super(deviceManager, id, name, address);
        this.initial = initial;
        this.shutdown = shutdown;
        this.dutyCycle = dutyCycle;
        this.frequency = frequency;
        this.polarity = polarity;
        this.pwmType = pwmType;
        this.pwm = deviceManager.execute(c -> {
            PwmConfig config = (PwmConfig)((PwmConfigBuilder)((PwmConfigBuilder)((PwmConfigBuilder)((PwmConfigBuilder)((PwmConfigBuilder)PwmConfigBuilder.newInstance(c).id(id)).name(name)).address(address.getValue())).initial(initial).pwmType(pwmType).description(this.getDescription())).dutyCycle(dutyCycle).frequency(frequency).polarity(polarity).shutdown(shutdown).provider(PiGpioPwmProvider.class)).build();
            return c.create(config);
        });
        deviceManager.addDevice(this);
    }

    public void on(Number dutyCycle, int frequency) {
        try {
            this.lock.lock();
            this.pwm.on(dutyCycle, frequency);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void on(int frequency) {
        try {
            this.lock.lock();
            this.pwm.on(frequency);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void off() {
        try {
            this.lock.lock();
            this.pwm.off();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isOn() {
        return this.pwm.isOn();
    }

    public boolean isOff() {
        return this.pwm.isOff();
    }

    public Number getInitial() {
        return this.initial;
    }

    public Number getShutdown() {
        return this.shutdown;
    }

    public Number getDutyCycle() {
        return this.dutyCycle;
    }

    public Integer getFrequency() {
        return this.frequency;
    }

    public PwmPolarity getPolarity() {
        return this.polarity;
    }

    public PwmType getPwmType() {
        return this.pwmType;
    }
}

