/*
 * Decompiled with CFR 0.152.
 */
package cn.tpkf.rpi.devices.gpio.digital.out;

import cn.tpkf.rpi.devices.gpio.digital.AbstractDigitalDevice;
import cn.tpkf.rpi.enums.IBCMEnums;
import cn.tpkf.rpi.manager.DeviceManager;
import com.pi4j.io.gpio.digital.DigitalOutput;
import com.pi4j.io.gpio.digital.DigitalOutputConfig;
import com.pi4j.io.gpio.digital.DigitalOutputConfigBuilder;
import com.pi4j.io.gpio.digital.DigitalState;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalOutputProvider;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractDoDevice
extends AbstractDigitalDevice {
    private static final Logger log = LoggerFactory.getLogger(AbstractDoDevice.class);
    private final DigitalOutput digitalOutput;
    private final DigitalState onState;
    private final DigitalState offState;

    public AbstractDoDevice(DeviceManager deviceManager, String id, String name, IBCMEnums address, DigitalState initial, DigitalState shutdown) {
        super(deviceManager, id, name, address);
        this.digitalOutput = deviceManager.execute(c -> {
            DigitalOutputConfig config = (DigitalOutputConfig)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)((DigitalOutputConfigBuilder)DigitalOutputConfigBuilder.newInstance(c).id(id)).name(name)).address(address.getValue())).initial(initial).shutdown(shutdown).description(this.getDescription())).provider(PiGpioDigitalOutputProvider.class)).build();
            return c.create(config);
        });
        if (DigitalState.LOW.equals(shutdown)) {
            this.onState = DigitalState.HIGH;
            this.offState = DigitalState.LOW;
        } else {
            this.onState = DigitalState.LOW;
            this.offState = DigitalState.HIGH;
        }
        deviceManager.addDevice(this);
    }

    public void on() {
        try {
            this.lock.lock();
            this.digitalOutput.state(this.onState);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void off() {
        try {
            this.lock.lock();
            this.digitalOutput.state(this.offState);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void toggle() {
        try {
            this.lock.lock();
            this.digitalOutput.toggle();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pulse(int duration, TimeUnit timeUnit, DigitalState digitalState) {
        try {
            this.lock.lock();
            this.digitalOutput.pulse(duration, timeUnit, digitalState);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void pulse(int duration, TimeUnit timeUnit) {
        this.pulse(duration, timeUnit, this.onState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blink(int duration, int cycle, TimeUnit timeUnit, DigitalState digitalState) {
        try {
            this.lock.lock();
            this.digitalOutput.blink(duration, cycle, timeUnit, digitalState);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void blink(int duration, int cycle, TimeUnit timeUnit) {
        this.blink(duration, cycle, timeUnit, this.onState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cycle(int times, long interval, int duration, int cycle, TimeUnit timeUnit, DigitalState digitalState) {
        try {
            this.lock.lock();
            while (times >= 1) {
                this.digitalOutput.blink(duration, cycle, timeUnit, digitalState);
                --times;
                timeUnit.sleep(interval);
            }
        }
        catch (InterruptedException e) {
            log.error("DigitalOutput device cycle error, thread has been interrupt: {}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void cycle(int times, long interval, int duration, int cycle, TimeUnit timeUnit) {
        this.cycle(times, interval, duration, cycle, timeUnit, this.onState);
    }

    @Override
    protected DigitalState getState() {
        return this.digitalOutput.state();
    }

    @Override
    protected boolean isHigh() {
        return this.digitalOutput.isHigh();
    }

    @Override
    protected boolean isLow() {
        return this.digitalOutput.isLow();
    }

    public DigitalState getOnState() {
        return this.onState;
    }

    public DigitalState getOffState() {
        return this.offState;
    }
}

