/*
 * Decompiled with CFR 0.152.
 */
package cn.tpkf.rpi.devices.gpio.digital.in;

import cn.tpkf.rpi.devices.gpio.digital.AbstractDigitalDevice;
import cn.tpkf.rpi.enums.IBCMEnums;
import cn.tpkf.rpi.manager.DeviceManager;
import com.pi4j.io.gpio.digital.DigitalInput;
import com.pi4j.io.gpio.digital.DigitalInputConfig;
import com.pi4j.io.gpio.digital.DigitalInputConfigBuilder;
import com.pi4j.io.gpio.digital.DigitalState;
import com.pi4j.io.gpio.digital.PullResistance;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalInputProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDIDevice
extends AbstractDigitalDevice {
    private static final Logger log = LoggerFactory.getLogger(AbstractDIDevice.class);
    protected final DigitalInput digitalInput;
    protected final PullResistance pull;
    protected final long debounceMicSec;
    protected final Runnable onUpTask;
    protected final Runnable onDownTask;

    protected AbstractDIDevice(DeviceManager deviceManager, String id, String name, IBCMEnums address, boolean inverted, long debounceMicSec, Runnable onUpTask, Runnable onDownTask) {
        super(deviceManager, id, name, address);
        this.pull = inverted ? PullResistance.PULL_UP : PullResistance.PULL_DOWN;
        this.debounceMicSec = debounceMicSec;
        this.onUpTask = onUpTask;
        this.onDownTask = onDownTask;
        this.digitalInput = deviceManager.execute(c -> {
            DigitalInputConfig config = (DigitalInputConfig)((DigitalInputConfigBuilder)((DigitalInputConfigBuilder)((DigitalInputConfigBuilder)((DigitalInputConfigBuilder)((DigitalInputConfigBuilder)DigitalInputConfigBuilder.newInstance(c).id(id)).name(name)).address(address.getValue())).description(this.getDescription())).pull(this.pull).debounce(debounceMicSec).provider(PiGpioDigitalInputProvider.class)).build();
            return c.create(config);
        });
        this.digitalInput.addListener(event -> {
            DigitalState state = this.getState();
            switch (state) {
                case HIGH: {
                    onUpTask.run();
                    break;
                }
                case LOW: {
                    onDownTask.run();
                    break;
                }
                case UNKNOWN: {
                    log.warn("Unknown state for device: {}", (Object)this.getDescription());
                }
            }
        });
        deviceManager.addDevice(this);
    }

    @Override
    protected DigitalState getState() {
        return this.digitalInput.state();
    }

    @Override
    protected boolean isHigh() {
        return this.digitalInput.isHigh();
    }

    @Override
    protected boolean isLow() {
        return this.digitalInput.isLow();
    }
}

