/*
 * Decompiled with CFR 0.152.
 */
package cn.torna.sdk.util;

import cn.torna.sdk.util.Base64Util;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RSAUtil {
    public static String RSA_ALGORITHM = "RSA";
    public static String UTF8 = "UTF-8";

    public static RSAPublicKey getPublicKey(byte[] pubKeyData) throws Exception {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(pubKeyData);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        return (RSAPublicKey)keyFactory.generatePublic(keySpec);
    }

    public static RSAPublicKey getPublicKey(String pubKey) throws Exception {
        return RSAUtil.getPublicKey(Base64Util.decodeBase64(pubKey));
    }

    public static String encryptByPublicKey(String data, String publicKey) throws Exception {
        return RSAUtil.encryptByPublicKey(data, RSAUtil.getPublicKey(publicKey));
    }

    public static String encryptByPublicKey(String data, RSAPublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
        cipher.init(1, publicKey);
        byte[] bytes = cipher.doFinal(data.getBytes(UTF8));
        return Base64Util.encodeBase64String(bytes);
    }

    public static String decryptByPublicKey(String data, String rsaPublicKey) throws Exception {
        return RSAUtil.decryptByPublicKey(data, RSAUtil.getPublicKey(rsaPublicKey));
    }

    public static String decryptByPublicKey(String data, RSAPublicKey rsaPublicKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
        cipher.init(2, rsaPublicKey);
        byte[] inputData = Base64Util.decodeBase64(data);
        byte[] bytes = cipher.doFinal(inputData);
        return new String(bytes, UTF8);
    }
}

