/*
 * Decompiled with CFR 0.152.
 */
package cn.torna.sdk.request;

import cn.torna.sdk.common.OpenConfig;
import cn.torna.sdk.common.RequestForm;
import cn.torna.sdk.common.UploadFile;
import cn.torna.sdk.response.BaseResponse;
import cn.torna.sdk.util.ClassUtil;
import cn.torna.sdk.util.JsonUtil;
import cn.torna.sdk.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public abstract class BaseRequest<T extends BaseResponse<?>> {
    @JSONField(serialize=false)
    private final String token;
    @JSONField(serialize=false)
    private List<UploadFile> files;
    @JSONField(serialize=false)
    private final Class<T> responseClass = ClassUtil.getSuperClassGenricType(this.getClass(), 0);

    @JSONField(serialize=false)
    public abstract String name();

    public BaseRequest(String token) {
        this.token = token;
    }

    @JSONField(serialize=false)
    protected String version() {
        return OpenConfig.defaultVersion;
    }

    public RequestForm createRequestForm() {
        String data = JSON.toJSONString((Object)this);
        HashMap<String, String> param = new HashMap<String, String>();
        String name = this.name();
        if (name == null) {
            throw new IllegalArgumentException("name\u4e0d\u80fd\u4e3anull");
        }
        param.put(OpenConfig.apiName, name);
        param.put(OpenConfig.dataName, StringUtil.encodeUrl(data));
        param.put(OpenConfig.timestampName, new SimpleDateFormat(OpenConfig.timestampPattern).format(new Date()));
        param.put(OpenConfig.versionName, this.version());
        param.put(OpenConfig.accessTokenName, this.token);
        RequestForm requestForm = new RequestForm(param);
        requestForm.setFiles(this.files);
        return requestForm;
    }

    public T parseResponse(String resp) {
        return (T)((BaseResponse)JsonUtil.parseObject(resp, this.getResponseClass()));
    }

    private void setFiles(List<UploadFile> files) {
        this.files = files;
    }

    private Class<T> getResponseClass() {
        return this.responseClass;
    }
}

